/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.concurrent;

import cn.ponfee.scheduler.common.concurrent.NamedThreadFactory;
import cn.ponfee.scheduler.common.util.Numbers;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutors.class);
    public static final int MAX_CAP = Short.MAX_VALUE;
    public static final RejectedExecutionHandler ABORT = new ThreadPoolExecutor.AbortPolicy();
    public static final RejectedExecutionHandler DISCARD = new ThreadPoolExecutor.DiscardPolicy();
    public static final RejectedExecutionHandler CALLER_RUNS = new ThreadPoolExecutor.CallerRunsPolicy();
    public static final RejectedExecutionHandler DISCARD_OLDEST = new ThreadPoolExecutor.DiscardOldestPolicy();
    public static final RejectedExecutionHandler CALLER_BLOCKS = (task, executor) -> {
        if (!executor.isShutdown()) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Put a task to queue occur error: BLOCK_PRODUCER", e);
            }
        }
    };
    public static final RejectedExecutionHandler ALWAYS_CALLER_RUNS = (task, executor) -> task.run();

    public static ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, long keepAliveTimeSeconds) {
        return ThreadPoolExecutors.create(corePoolSize, maximumPoolSize, keepAliveTimeSeconds, 0, null, null);
    }

    public static ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, long keepAliveTimeSeconds, int queueCapacity) {
        return ThreadPoolExecutors.create(corePoolSize, maximumPoolSize, keepAliveTimeSeconds, queueCapacity, null, null);
    }

    public static ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, long keepAliveTimeSeconds, int queueCapacity, RejectedExecutionHandler rejectedHandler) {
        return ThreadPoolExecutors.create(corePoolSize, maximumPoolSize, keepAliveTimeSeconds, queueCapacity, null, rejectedHandler);
    }

    public static ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, long keepAliveTimeSeconds, int queueCapacity, String threadName) {
        return ThreadPoolExecutors.create(corePoolSize, maximumPoolSize, keepAliveTimeSeconds, queueCapacity, threadName, null);
    }

    public static ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, long keepAliveTimeSeconds, int queueCapacity, String threadName, RejectedExecutionHandler rejectedHandler) {
        LinkedBlockingQueue<Runnable> workQueue = queueCapacity > 0 ? new LinkedBlockingQueue(queueCapacity) : new SynchronousQueue();
        NamedThreadFactory threadFactory = NamedThreadFactory.builder().prefix(threadName).build();
        if (rejectedHandler == null) {
            rejectedHandler = CALLER_RUNS;
        }
        maximumPoolSize = Numbers.bound(maximumPoolSize, 1, Short.MAX_VALUE);
        corePoolSize = Numbers.bound(corePoolSize, 1, maximumPoolSize);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTimeSeconds, TimeUnit.SECONDS, workQueue, threadFactory, rejectedHandler);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static boolean shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            while (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Shutdown ExecutorService occur error.", (Throwable)e);
            executorService.shutdownNow();
            return false;
        }
    }

    public static boolean shutdown(ExecutorService executorService, int awaitSeconds) {
        boolean isSafeTerminated;
        block3: {
            executorService.shutdown();
            isSafeTerminated = false;
            boolean hasCallShutdownNow = false;
            try {
                isSafeTerminated = executorService.awaitTermination(awaitSeconds, TimeUnit.SECONDS);
                if (!isSafeTerminated) {
                    hasCallShutdownNow = true;
                    executorService.shutdownNow();
                }
            }
            catch (Exception e) {
                LOG.error("Shutdown ExecutorService occur error.", (Throwable)e);
                if (hasCallShutdownNow) break block3;
                executorService.shutdownNow();
            }
        }
        return isSafeTerminated;
    }
}

