/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.date;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public class LocalDateFormat {
    private static final DateTimeFormatter PATTERN_01 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter PATTERN_02 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter PATTERN_03 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    public static final LocalDateFormat DEFAULT = new LocalDateFormat("yyyy-MM-dd");
    private final DateTimeFormatter backstopFormat;

    public LocalDateFormat(String pattern) {
        this(DateTimeFormatter.ofPattern(pattern));
    }

    public LocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.backstopFormat = dateTimeFormatter;
    }

    public LocalDate parse(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        int length = source.length();
        switch (length) {
            case 8: {
                return LocalDate.parse(source, PATTERN_01);
            }
            case 10: {
                char c = source.charAt(4);
                if (c == '-') {
                    return LocalDate.parse(source, PATTERN_02);
                }
                if (c != '/') break;
                return LocalDate.parse(source, PATTERN_03);
            }
        }
        throw new IllegalArgumentException("Invalid local date format: " + source);
    }

    public String format(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return this.backstopFormat.format(localDate);
    }
}

