/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.spring;

import cn.ponfee.scheduler.common.spring.LocalizedMethodArguments;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class LocalizedMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Set<String> QUERY_PARAM_METHODS = ImmutableSet.of((Object)RequestMethod.GET.name(), (Object)RequestMethod.DELETE.name(), (Object)RequestMethod.HEAD.name(), (Object)RequestMethod.OPTIONS.name());
    private static final String CACHE_ATTRIBUTE_KEY = "LOCALIZED_METHOD_ARGUMENTS";
    private static final Class<? extends Annotation> MARKED_ANNOTATION_TYPE = LocalizedMethodArguments.class;
    private final ObjectMapper objectMapper;

    public LocalizedMethodArgumentResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (!(parameter.getExecutable() instanceof Method)) {
            return false;
        }
        return LocalizedMethodArgumentResolver.isAnnotationPresent(parameter.getMethod(), MARKED_ANNOTATION_TYPE) || LocalizedMethodArgumentResolver.isAnnotationPresent(parameter.getDeclaringClass(), MARKED_ANNOTATION_TYPE);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException {
        Object[] arguments;
        Method method = Objects.requireNonNull(parameter.getMethod());
        HttpServletRequest httpServletRequest = (HttpServletRequest)Objects.requireNonNull(webRequest.getNativeRequest(HttpServletRequest.class));
        int parameterIndex = parameter.getParameterIndex();
        if (parameterIndex == 0) {
            arguments = this.parseMethodParameters(method, httpServletRequest);
            if (method.getParameterCount() > 1) {
                httpServletRequest.setAttribute(CACHE_ATTRIBUTE_KEY, (Object)arguments);
            }
        } else {
            arguments = (Object[])httpServletRequest.getAttribute(CACHE_ATTRIBUTE_KEY);
        }
        return Collects.get(arguments, parameterIndex);
    }

    private Object[] parseMethodParameters(Method method, HttpServletRequest request) throws IOException {
        if (QUERY_PARAM_METHODS.contains(request.getMethod())) {
            return this.parseQueryString(method, request.getParameterMap());
        }
        try (ServletInputStream inputStream = request.getInputStream();){
            String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)body)) {
                Object[] objectArray = this.parseQueryString(method, request.getParameterMap());
                return objectArray;
            }
            Object[] objectArray = this.parseRequestBody(method, body);
            return objectArray;
        }
    }

    private Object[] parseQueryString(Method method, Map<String, String[]> parameterMap) {
        int parameterCount = method.getParameterCount();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            String argName = "args[" + i + "]";
            String[] array = parameterMap.get(argName);
            Assert.isTrue((array == null || array.length <= 1 ? 1 : 0) != 0, () -> "Argument cannot be multiple value, name: " + argName + ", value: " + Jsons.toJson(array));
            String argValue = Collects.get(array, 0);
            Type argType = method.getGenericParameterTypes()[i];
            arguments[i] = argValue == null ? (argType instanceof Class ? ObjectUtils.cast(null, (Class)argType) : null) : Jsons.fromJson(argValue, argType);
        }
        return arguments;
    }

    private Object[] parseRequestBody(Method method, String body) throws IOException {
        Type[] genericArgumentTypes = method.getGenericParameterTypes();
        int argumentCount = genericArgumentTypes.length;
        if (argumentCount == 0) {
            return null;
        }
        JsonNode rootNode = this.objectMapper.readTree(body);
        if (rootNode.isArray()) {
            ArrayNode requestParameters = (ArrayNode)rootNode;
            if (argumentCount == 1 && requestParameters.size() > 1) {
                return new Object[]{this.parse(rootNode, genericArgumentTypes[0])};
            }
            Assert.isTrue((argumentCount == requestParameters.size() ? 1 : 0) != 0, () -> "Method arguments size: " + argumentCount + ", but actual size: " + requestParameters.size());
            Object[] methodArguments = new Object[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                methodArguments[i] = this.parse(requestParameters.get(i), genericArgumentTypes[i]);
            }
            return methodArguments;
        }
        Assert.isTrue((argumentCount == 1 ? 1 : 0) != 0, (String)"Single object request parameter not support multiple arguments method.");
        return new Object[]{this.parse(rootNode, genericArgumentTypes[0])};
    }

    private Object parse(JsonNode jsonNode, Type type) throws IOException {
        return this.objectMapper.readerFor(this.objectMapper.getTypeFactory().constructType(type)).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(this.objectMapper.treeAsTokens((TreeNode)jsonNode));
    }

    private static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation((Method)method, annotationType) != null;
    }

    private static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(clazz, annotationType) != null;
    }
}

