/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class Bytes {
    private static final char[] HEX_LOWER_CODES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_UPPER_CODES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void hexEncode(char[] charArray, int i, byte b) {
        charArray[i] = HEX_LOWER_CODES[(0xF0 & b) >>> 4];
        charArray[++i] = HEX_LOWER_CODES[0xF & b];
    }

    public static String hexEncode(byte b, boolean lowercase) {
        char[] codes = lowercase ? HEX_LOWER_CODES : HEX_UPPER_CODES;
        return new String(new char[]{codes[(0xF0 & b) >>> 4], codes[0xF & b]});
    }

    public static String hexEncode(byte[] bytes) {
        return Bytes.hexEncode(bytes, true);
    }

    public static String hexEncode(byte[] bytes, boolean lowercase) {
        int len = bytes.length;
        char[] out = new char[len << 1];
        char[] codes = lowercase ? HEX_LOWER_CODES : HEX_UPPER_CODES;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = codes[(0xF0 & bytes[i]) >>> 4];
            out[j++] = codes[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static byte[] hexDecode(String hex) {
        char[] data = hex.toCharArray();
        int len = data.length;
        if ((len & 1) == 1) {
            throw new IllegalArgumentException("Invalid hex string.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        for (int j = 0; j < len; j += 2) {
            out[i] = (byte)(Character.digit(data[j], 16) << 4 | Character.digit(data[j + 1], 16));
            ++i;
        }
        return out;
    }

    public static char[] toCharArray(byte[] bytes) {
        return Bytes.toCharArray(bytes, StandardCharsets.US_ASCII);
    }

    public static char[] toCharArray(byte[] bytes, Charset charset) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return charset.decode(buffer).array();
    }

    public static byte[] toBytes(char[] chars) {
        return Bytes.toBytes(chars, StandardCharsets.US_ASCII);
    }

    public static byte[] toBytes(char[] chars, Charset charset) {
        CharBuffer buffer = CharBuffer.allocate(chars.length);
        buffer.put(chars);
        buffer.flip();
        return charset.encode(buffer).array();
    }

    public static byte[] toBytes(char value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    public static char toChar(byte[] bytes) {
        return Bytes.toChar(bytes, 0);
    }

    public static char toChar(byte[] bytes, int fromIdx) {
        return (char)(bytes[fromIdx] << 8 | bytes[++fromIdx] & 0xFF);
    }

    public static byte[] toBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0);
    }

    public static int toInt(byte[] bytes, int fromIdx) {
        return bytes[fromIdx] << 24 | (bytes[++fromIdx] & 0xFF) << 16 | (bytes[++fromIdx] & 0xFF) << 8 | bytes[++fromIdx] & 0xFF;
    }

    public static byte[] toBytes(long value) {
        return new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static String toHex(long value) {
        return Bytes.toHex(value, true);
    }

    public static String toHex(long value, boolean lowercase) {
        char[] a = lowercase ? HEX_LOWER_CODES : HEX_UPPER_CODES;
        int mask = 15;
        return new String(new char[]{a[(int)(value >>> 60)], a[mask & (int)(value >>> 56)], a[mask & (int)(value >>> 52)], a[mask & (int)(value >>> 48)], a[mask & (int)(value >>> 44)], a[mask & (int)(value >>> 40)], a[mask & (int)(value >>> 36)], a[mask & (int)(value >>> 32)], a[mask & (int)(value >>> 28)], a[mask & (int)(value >>> 24)], a[mask & (int)(value >>> 20)], a[mask & (int)(value >>> 16)], a[mask & (int)(value >>> 12)], a[mask & (int)(value >>> 8)], a[mask & (int)(value >>> 4)], a[mask & (int)value]});
    }

    public static long toLong(byte[] bytes, int fromIdx) {
        return (long)bytes[fromIdx] << 56 | ((long)bytes[++fromIdx] & 0xFFL) << 48 | ((long)bytes[++fromIdx] & 0xFFL) << 40 | ((long)bytes[++fromIdx] & 0xFFL) << 32 | ((long)bytes[++fromIdx] & 0xFFL) << 24 | ((long)bytes[++fromIdx] & 0xFFL) << 16 | ((long)bytes[++fromIdx] & 0xFFL) << 8 | (long)bytes[++fromIdx] & 0xFFL;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0);
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(val.scale(), result, 0);
        System.arraycopy(valueBytes, 0, result, offset, valueBytes.length);
        return result;
    }

    public static int putInt(int val, byte[] bytes, int offset) {
        bytes[offset] = (byte)(val >>> 24);
        bytes[++offset] = (byte)(val >>> 16);
        bytes[++offset] = (byte)(val >>> 8);
        bytes[++offset] = (byte)val;
        return ++offset;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static BigInteger toBigInteger(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, bytes);
    }

    public static byte[] concat(byte[] first, byte[] ... rest) {
        Objects.requireNonNull(first, "the first array arg cannot be null");
        if (rest == null || rest.length == 0) {
            return first;
        }
        int totalLength = first.length;
        for (byte[] array : rest) {
            if (array == null) continue;
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }
}

