/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.concurrent;

import cn.ponfee.scheduler.common.concurrent.DelayedData;
import cn.ponfee.scheduler.common.concurrent.NamedThreadFactory;
import cn.ponfee.scheduler.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.scheduler.common.concurrent.Threads;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncDelayedExecutor<E>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDelayedExecutor.class);
    private final Consumer<E> processor;
    private final ThreadPoolExecutor asyncExecutor;
    private final DelayQueue<DelayedData<E>> queue = new DelayQueue();
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public AsyncDelayedExecutor(Consumer<E> processor) {
        this(1, processor);
    }

    public AsyncDelayedExecutor(int maximumPoolSize, Consumer<E> processor) {
        this.processor = processor;
        ThreadPoolExecutor executor = null;
        if (maximumPoolSize > 1) {
            executor = ThreadPoolExecutors.builder().corePoolSize(1).maximumPoolSize(maximumPoolSize).workQueue(new SynchronousQueue<Runnable>()).keepAliveTimeSeconds(300L).threadFactory(NamedThreadFactory.builder().prefix("async_delayed_worker").build()).rejectedHandler(ThreadPoolExecutors.CALLER_RUNS).build();
        }
        this.asyncExecutor = executor;
        super.setName("async_delayed_executor-" + Integer.toHexString(this.hashCode()));
        super.setDaemon(false);
        super.start();
    }

    public boolean put(DelayedData<E> delayedData) {
        if (this.stopped.get()) {
            return false;
        }
        return this.queue.offer(delayedData);
    }

    public void doStop() {
        if (this.stopped.compareAndSet(false, true)) {
            Threads.stopThread(this, 0, 0L, 1000L);
        }
    }

    @Override
    public void run() {
        while (!this.stopped.get()) {
            DelayedData delayed;
            try {
                delayed = (DelayedData)this.queue.poll(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("Delayed queue pool occur interrupted.", (Throwable)e);
                this.stopped.compareAndSet(false, true);
                Thread.currentThread().interrupt();
                break;
            }
            if (delayed == null) continue;
            Object data = delayed.getData();
            if (this.asyncExecutor != null) {
                this.asyncExecutor.submit(() -> this.processor.accept(data));
                continue;
            }
            this.processor.accept(data);
        }
        if (this.asyncExecutor != null) {
            ThreadPoolExecutors.shutdown(this.asyncExecutor, 1);
        }
    }
}

