/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.concurrent;

import cn.ponfee.scheduler.common.concurrent.Threads;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class ThreadPoolExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutors.class);
    public static final int MAX_CAP = Short.MAX_VALUE;
    public static final RejectedExecutionHandler ABORT = new ThreadPoolExecutor.AbortPolicy();
    public static final RejectedExecutionHandler DISCARD = new ThreadPoolExecutor.DiscardPolicy();
    public static final RejectedExecutionHandler CALLER_RUNS = new ThreadPoolExecutor.CallerRunsPolicy();
    public static final RejectedExecutionHandler DISCARD_OLDEST = new ThreadPoolExecutor.DiscardOldestPolicy();
    public static final RejectedExecutionHandler CALLER_BLOCKS = (task, executor) -> {
        if (!executor.isShutdown()) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Put a task to queue occur error: BLOCK_PRODUCER", e);
            }
        }
    };
    public static final RejectedExecutionHandler ALWAYS_CALLER_RUNS = (task, executor) -> task.run();

    public static Builder builder() {
        return new Builder();
    }

    public static boolean shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            while (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Shutdown ExecutorService occur error.", (Throwable)e);
            executorService.shutdownNow();
            Threads.interruptIfNecessary(e);
            return false;
        }
    }

    public static boolean shutdown(ExecutorService executorService, int awaitSeconds) {
        executorService.shutdown();
        boolean isSafeTerminated = false;
        boolean hasCallShutdownNow = false;
        try {
            isSafeTerminated = executorService.awaitTermination(awaitSeconds, TimeUnit.SECONDS);
            if (!isSafeTerminated) {
                hasCallShutdownNow = true;
                executorService.shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.error("Shutdown ExecutorService occur error.", (Throwable)e);
            if (!hasCallShutdownNow) {
                executorService.shutdownNow();
            }
            Threads.interruptIfNecessary(e);
        }
        return isSafeTerminated;
    }

    public static class Builder {
        private int corePoolSize;
        private int maximumPoolSize;
        private BlockingQueue<Runnable> workQueue;
        private long keepAliveTimeSeconds;
        private RejectedExecutionHandler rejectedHandler;
        private ThreadFactory threadFactory;
        private boolean allowCoreThreadTimeOut = true;
        private PrestartCoreThreadType prestartCoreThreadType = PrestartCoreThreadType.NONE;

        private Builder() {
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Builder workQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public Builder keepAliveTimeSeconds(long keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        public Builder rejectedHandler(RejectedExecutionHandler rejectedHandler) {
            this.rejectedHandler = rejectedHandler;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
            return this;
        }

        public Builder prestartCoreThreadType(PrestartCoreThreadType prestartCoreThreadType) {
            this.prestartCoreThreadType = prestartCoreThreadType;
            return this;
        }

        public ThreadPoolExecutor build() {
            Assert.isTrue((this.maximumPoolSize > 0 ? 1 : 0) != 0, () -> String.format("Maximum pool size %d must greater than 0.", this.maximumPoolSize));
            Assert.isTrue((this.maximumPoolSize <= Short.MAX_VALUE ? 1 : 0) != 0, () -> String.format("Maximum pool size %d cannot greater than %d.", this.maximumPoolSize, Short.MAX_VALUE));
            Assert.isTrue((this.corePoolSize > 0 ? 1 : 0) != 0, () -> String.format("Core pool size %d must greater than 0.", this.corePoolSize));
            Assert.isTrue((this.corePoolSize <= this.maximumPoolSize ? 1 : 0) != 0, () -> String.format("Core pool size %d cannot greater than maximum pool size %d.", this.corePoolSize, this.maximumPoolSize));
            Assert.notNull(this.workQueue, (String)"Worker queue cannot be null.");
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, this.workQueue, this.threadFactory != null ? this.threadFactory : Executors.defaultThreadFactory(), this.rejectedHandler != null ? this.rejectedHandler : CALLER_RUNS);
            threadPoolExecutor.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
            if (this.prestartCoreThreadType == PrestartCoreThreadType.ONE) {
                threadPoolExecutor.prestartCoreThread();
            } else if (this.prestartCoreThreadType == PrestartCoreThreadType.ALL) {
                threadPoolExecutor.prestartAllCoreThreads();
            }
            return threadPoolExecutor;
        }
    }

    public static enum PrestartCoreThreadType {
        NONE,
        ONE,
        ALL;

    }
}

