/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.date;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class Dates {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ZERO_DATE_TIME = "0000-00-00 00:00:00";

    public static boolean isValidDate(String date) {
        return Dates.isValidDate(date, DEFAULT_DATE_FORMAT);
    }

    public static boolean isValidDate(String date, String pattern) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return false;
        }
        try {
            Dates.toDate(date, pattern);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isZeroDate(Date date) {
        return date != null && date.getTime() == -62170185600000L;
    }

    public static Date now() {
        return new Date();
    }

    public static String now(String format) {
        return Dates.format(Dates.now(), format);
    }

    public static Date toDate(String dateStr) {
        return Dates.toDate(dateStr, DEFAULT_DATE_FORMAT);
    }

    public static Date toDate(String dateStr, String pattern) {
        return DateTimeFormat.forPattern((String)pattern).parseDateTime(dateStr).toDate();
    }

    public static Date ofMillis(long timeMillis) {
        return new Date(timeMillis);
    }

    public static Date ofMillis(Long timeMillis) {
        return timeMillis == null ? null : new Date(timeMillis);
    }

    public static Date ofSeconds(long unixTimeSeconds) {
        return new Date(unixTimeSeconds * 1000L);
    }

    public static Date ofSeconds(Long unixTimeSeconds) {
        return unixTimeSeconds == null ? null : new Date(unixTimeSeconds * 1000L);
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date).toString(format);
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date).toString(DEFAULT_DATE_FORMAT);
    }

    public static String format(long mills, String pattern) {
        return new DateTime(mills).toString(pattern);
    }

    public static Date plusMillis(@Nonnull Date date, int numOfMillis) {
        return new DateTime((Object)date).plusMillis(numOfMillis).toDate();
    }

    public static Date plusSeconds(@Nonnull Date date, int numOfSeconds) {
        return new DateTime((Object)date).plusSeconds(numOfSeconds).toDate();
    }

    public static Date plusMinutes(@Nonnull Date date, int numOfMinutes) {
        return new DateTime((Object)date).plusMinutes(numOfMinutes).toDate();
    }

    public static Date plusHours(@Nonnull Date date, int numOfHours) {
        return new DateTime((Object)date).plusHours(numOfHours).toDate();
    }

    public static Date plusDays(@Nonnull Date date, int numdays) {
        return new DateTime((Object)date).plusDays(numdays).toDate();
    }

    public static Date plusWeeks(@Nonnull Date date, int numWeeks) {
        return new DateTime((Object)date).plusWeeks(numWeeks).toDate();
    }

    public static Date plusMonths(@Nonnull Date date, int numMonths) {
        return new DateTime((Object)date).plusMonths(numMonths).toDate();
    }

    public static Date plusYears(@Nonnull Date date, int numYears) {
        return new DateTime((Object)date).plusYears(numYears).toDate();
    }

    public static Date minusMillis(@Nonnull Date date, int numOfMillis) {
        return new DateTime((Object)date).minusMillis(numOfMillis).toDate();
    }

    public static Date minusSeconds(@Nonnull Date date, int numOfSeconds) {
        return new DateTime((Object)date).minusSeconds(numOfSeconds).toDate();
    }

    public static Date minusMinutes(@Nonnull Date date, int numOfMinutes) {
        return new DateTime((Object)date).minusMinutes(numOfMinutes).toDate();
    }

    public static Date minusHours(@Nonnull Date date, int numOfHours) {
        return new DateTime((Object)date).minusHours(numOfHours).toDate();
    }

    public static Date minusDays(@Nonnull Date date, int numdays) {
        return new DateTime((Object)date).minusDays(numdays).toDate();
    }

    public static Date minusWeeks(@Nonnull Date date, int numWeeks) {
        return new DateTime((Object)date).minusWeeks(numWeeks).toDate();
    }

    public static Date minusMonths(@Nonnull Date date, int numMonths) {
        return new DateTime((Object)date).minusMonths(numMonths).toDate();
    }

    public static Date minusYears(@Nonnull Date date, int numYears) {
        return new DateTime((Object)date).minusYears(numYears).toDate();
    }

    public static Date startOfDay(@Nonnull Date date) {
        return Dates.startOfDay(new DateTime((Object)date));
    }

    public static Date endOfDay(@Nonnull Date date) {
        return Dates.endOfDay(new DateTime((Object)date));
    }

    public static Date startOfWeek(@Nonnull Date date) {
        return Dates.startOfDay(new DateTime((Object)date).dayOfWeek().withMinimumValue());
    }

    public static Date endOfWeek(@Nonnull Date date) {
        return Dates.endOfDay(new DateTime((Object)date).dayOfWeek().withMaximumValue());
    }

    public static Date startOfMonth(@Nonnull Date date) {
        return Dates.startOfDay(new DateTime((Object)date).dayOfMonth().withMinimumValue());
    }

    public static Date endOfMonth(@Nonnull Date date) {
        return Dates.endOfDay(new DateTime((Object)date).dayOfMonth().withMaximumValue());
    }

    public static Date startOfYear(@Nonnull Date date) {
        return Dates.startOfDay(new DateTime((Object)date).dayOfYear().withMinimumValue());
    }

    public static Date endOfYear(@Nonnull Date date) {
        return Dates.endOfDay(new DateTime((Object)date).dayOfYear().withMaximumValue());
    }

    public static Date withDayOfWeek(@Nonnull Date date, int day) {
        return Dates.startOfDay(new DateTime((Object)date).withDayOfWeek(day));
    }

    public static Date withDayOfMonth(@Nonnull Date date, int day) {
        return Dates.startOfDay(new DateTime((Object)date).withDayOfMonth(day));
    }

    public static Date withDayOfYear(@Nonnull Date date, int day) {
        return Dates.startOfDay(new DateTime((Object)date).withDayOfYear(day));
    }

    public static int dayOfYear(@Nonnull Date date) {
        return new DateTime((Object)date).getDayOfYear();
    }

    public static int dayOfMonth(@Nonnull Date date) {
        return new DateTime((Object)date).getDayOfMonth();
    }

    public static int dayOfWeek(@Nonnull Date date) {
        return new DateTime((Object)date).getDayOfWeek();
    }

    public static int hourOfDay(@Nonnull Date date) {
        return new DateTime((Object)date).getHourOfDay();
    }

    public static long clockDiff(@Nonnull Date start, @Nonnull Date end) {
        return (end.getTime() - start.getTime()) / 1000L;
    }

    public static int daysBetween(Date start, Date end) {
        return Days.daysBetween((ReadableInstant)new DateTime((Object)start), (ReadableInstant)new DateTime((Object)end)).getDays();
    }

    public static Date random(Date begin, Date end) {
        long endMills;
        long beginMills = begin.getTime();
        if (beginMills >= (endMills = end.getTime())) {
            throw new IllegalArgumentException("Date [" + Dates.format(begin) + "] must before [" + Dates.format(end) + "]");
        }
        return Dates.random(beginMills, endMills);
    }

    public static Date random(long beginMills, long endMills) {
        if (beginMills >= endMills) {
            throw new IllegalArgumentException("Date [" + beginMills + "] must before [" + endMills + "]");
        }
        return new Date(beginMills + ThreadLocalRandom.current().nextLong(endMills - beginMills));
    }

    public static Date min(Date a, Date b) {
        return a == null ? b : (b == null || a.before(b) ? a : b);
    }

    public static Date max(Date a, Date b) {
        return a == null ? b : (b == null || a.after(b) ? a : b);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date zoneConvert(Date date, ZoneId sourceZone, ZoneId targetZone) {
        if (date == null || sourceZone.equals(targetZone)) {
            return date;
        }
        return Date.from(date.toInstant().atZone(targetZone).withZoneSameLocal(sourceZone).toInstant());
    }

    public static LocalDateTime zoneConvert(LocalDateTime localDateTime, ZoneId sourceZone, ZoneId targetZone) {
        if (localDateTime == null || sourceZone.equals(targetZone)) {
            return localDateTime;
        }
        return ZonedDateTime.of(localDateTime, sourceZone).withZoneSameInstant(targetZone).toLocalDateTime();
    }

    public static String zoneConvert(String date, ZoneId sourceZone, ZoneId targetZone) {
        return Dates.zoneConvert(date, DEFAULT_DATE_FORMAT, sourceZone, targetZone);
    }

    public static String zoneConvert(String date, String pattern, ZoneId sourceZone, ZoneId targetZone) {
        if (date == null || sourceZone.equals(targetZone)) {
            return date;
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime source = LocalDateTime.parse(date, format);
        LocalDateTime target = Dates.zoneConvert(source, sourceZone, targetZone);
        return target.format(format);
    }

    public static String toCronExpression(Date date) {
        return Dates.toCronExpression(Dates.toLocalDateTime(date));
    }

    public static String toCronExpression(LocalDateTime dateTime) {
        return new StringBuilder(22).append(dateTime.getSecond()).append(' ').append(dateTime.getMinute()).append(' ').append(dateTime.getHour()).append(' ').append(dateTime.getDayOfMonth()).append(' ').append(dateTime.getMonthValue()).append(' ').append('?').append(' ').append(dateTime.getYear()).toString();
    }

    private static Date endOfDay(DateTime date) {
        return date.withTime(23, 59, 59, 0).toDate();
    }

    private static Date startOfDay(DateTime date) {
        return date.withTimeAtStartOfDay().toDate();
    }
}

