/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.exception;

import cn.ponfee.scheduler.common.concurrent.Threads;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Throwables {
    private static final Logger LOG = LoggerFactory.getLogger(Throwables.class);

    public static String getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = list.size() - 1; i >= 0; --i) {
            String message = ((Throwable)list.get(i)).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            return "error: " + message;
        }
        return "error: <" + ClassUtils.getName(throwable.getClass()) + ">";
    }

    public static <T extends Throwable> Runnable runnable(ThrowingRunnable<T> runnable) {
        return ThrowingRunnable.checked(runnable);
    }

    public static <R, T extends Throwable> Callable<R> callable(ThrowingCallable<R, T> callable) {
        return ThrowingCallable.checked(callable);
    }

    public static <E, T extends Throwable> Consumer<E> consumer(ThrowingConsumer<E, T> consumer) {
        return ThrowingConsumer.checked(consumer);
    }

    public static <E, R, T extends Throwable> Function<E, R> function(ThrowingFunction<E, R, T> function) {
        return ThrowingFunction.checked(function);
    }

    public static <R, T extends Throwable> Supplier<R> supplier(ThrowingSupplier<R, T> supplier) {
        return ThrowingSupplier.checked(supplier);
    }

    public static <E, T extends Throwable> Comparator<? super E> comparator(ThrowingComparator<E, T> comparator) {
        return ThrowingComparator.checked(comparator);
    }

    public static void caught(ThrowingRunnable<?> runnable) {
        Throwables.caught(runnable, "");
    }

    public static void caught(ThrowingRunnable<?> runnable, String message) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            LOG.error(message == null ? "" : message, t);
            Threads.interruptIfNecessary(t);
        }
    }

    public static void caught(ThrowingRunnable<?> runnable, Supplier<String> message) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            LOG.error(message.get(), t);
            Threads.interruptIfNecessary(t);
        }
    }

    public static <R> R caught(ThrowingSupplier<R, ?> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            Threads.interruptIfNecessary(t);
            return null;
        }
    }

    public static <E> void caught(ThrowingConsumer<E, ?> consumer, E arg) {
        try {
            consumer.accept(arg);
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            Threads.interruptIfNecessary(t);
        }
    }

    public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg) {
        return Throwables.caught(function, arg, null);
    }

    public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg, R defaultValue) {
        try {
            return function.apply(arg);
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            Threads.interruptIfNecessary(t);
            return defaultValue;
        }
    }

    public static void checked(ThrowingRunnable<?> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public static <R> R checked(ThrowingSupplier<R, ?> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return (R)ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public static <E> void checked(ThrowingConsumer<E, ?> consumer, E arg) {
        try {
            consumer.accept(arg);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public static <E, R> R checked(ThrowingFunction<E, R, ?> function, E arg) {
        return Throwables.caught(function, arg, null);
    }

    public static <E, R> R checked(ThrowingFunction<E, R, ?> function, E arg, R defaultValue) {
        try {
            return function.apply(arg);
        }
        catch (Throwable t) {
            return (R)ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public static void ignored(ThrowingRunnable<?> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <R> R ignored(ThrowingSupplier<R, ?> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ThrowingComparator<E, T extends Throwable> {
        public int compare(E var1, E var2) throws T;

        public static <E, T extends Throwable> Comparator<? super E> checked(ThrowingComparator<E, T> comparator) {
            return (e1, e2) -> {
                try {
                    return comparator.compare(e1, e2);
                }
                catch (Throwable t) {
                    return (Integer)ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, T extends Throwable> {
        public R get() throws T;

        public static <R, T extends Throwable> Supplier<R> checked(ThrowingSupplier<R, T> supplier) {
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingFunction<E, R, T extends Throwable> {
        public R apply(E var1) throws T;

        public static <E, R, T extends Throwable> Function<E, R> checked(ThrowingFunction<E, R, T> function) {
            return e -> {
                try {
                    return function.apply(e);
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<E, T extends Throwable> {
        public void accept(E var1) throws T;

        public static <E, T extends Throwable> Consumer<E> checked(ThrowingConsumer<E, T> consumer) {
            return e -> {
                try {
                    consumer.accept(e);
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingCallable<R, T extends Throwable> {
        public R call() throws T;

        public static <R, T extends Throwable> Callable<R> checked(ThrowingCallable<R, T> callable) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Throwable> {
        public void run() throws T;

        public static <T extends Throwable> Runnable checked(ThrowingRunnable<T> runnable) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }
    }
}

