/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.graph;

import cn.ponfee.scheduler.common.base.ToJsonString;
import cn.ponfee.scheduler.common.graph.DAGNode;
import com.google.common.graph.EndpointPair;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

public final class DAGEdge
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 2292231888365728538L;
    private final DAGNode source;
    private final DAGNode target;

    private DAGEdge(DAGNode source, DAGNode target) {
        this.source = source;
        this.target = target;
    }

    public static DAGEdge of(DAGNode source, DAGNode target) {
        Assert.notNull((Object)source, () -> "DAG source node cannot be null.");
        Assert.notNull((Object)target, () -> "DAG target node cannot be null.");
        return new DAGEdge(source, target);
    }

    public static DAGEdge of(String source, String target) {
        Assert.notNull((Object)source, () -> "DAG source node cannot be blank.");
        Assert.notNull((Object)target, () -> "DAG target node cannot be blank.");
        return new DAGEdge(DAGNode.fromString(source), DAGNode.fromString(target));
    }

    public static DAGEdge of(EndpointPair<DAGNode> pair) {
        Assert.notNull(pair, () -> "DAG node pair cannot be blank.");
        return new DAGEdge((DAGNode)pair.source(), (DAGNode)pair.target());
    }

    public DAGNode getSource() {
        return this.source;
    }

    public DAGNode getTarget() {
        return this.target;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DAGEdge)) {
            return false;
        }
        DAGEdge other = (DAGEdge)obj;
        return this.source.equals(other.source) && this.target.equals(other.target);
    }
}

