/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.lock;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import java.sql.PreparedStatement;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public final class DoInDatabaseLocked
implements DoInLocked {
    private static final Logger LOG = LoggerFactory.getLogger(DoInDatabaseLocked.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockSql;

    public DoInDatabaseLocked(JdbcTemplate jdbcTemplate, String lockSql) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockSql = lockSql;
    }

    @Override
    public <T> T action(Callable<T> caller) {
        return (T)this.jdbcTemplate.execute(connection -> {
            Boolean autoCommit = null;
            PreparedStatement ps = null;
            try {
                autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                ps = connection.prepareStatement(this.lockSql);
                ps.execute();
                Object v = caller.call();
                return v;
            }
            catch (Exception e) {
                LOG.error("Do in db lock occur error.", (Throwable)e);
                Object var6_11 = null;
                return var6_11;
            }
            finally {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    LOG.error("Commit connection occur error.", (Throwable)e);
                }
                if (autoCommit != null) {
                    try {
                        connection.setAutoCommit(autoCommit);
                    }
                    catch (Exception e) {
                        LOG.error("Restore connection auto-commit occur error.", (Throwable)e);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        LOG.error("Close prepare statement occur error.", (Throwable)e);
                    }
                }
            }
        });
    }
}

