/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.lock;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.lock.RedisLock;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoInRedisLocked
implements DoInLocked {
    private static final Logger LOG = LoggerFactory.getLogger(DoInRedisLocked.class);
    private final RedisLock redisLock;

    public DoInRedisLocked(RedisLock redisLock) {
        this.redisLock = redisLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T action(Callable<T> caller) {
        if (!this.redisLock.tryLock()) {
            return null;
        }
        try {
            T t = caller.call();
            return t;
        }
        catch (Exception e) {
            LOG.error("Do in redis lock occur error.", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            this.redisLock.unlock();
        }
    }
}

