/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.spring;

import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.common.util.Jsons;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    public static final Set<HttpMethod> QUERY_PARAM_METHODS = ImmutableSet.of((Object)HttpMethod.GET, (Object)HttpMethod.DELETE, (Object)HttpMethod.HEAD, (Object)HttpMethod.OPTIONS);

    public static MappingJackson2HttpMessageConverter buildJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(Jsons.createObjectMapper(JsonInclude.Include.NON_NULL));
        RestTemplateUtils.extensionSupportedMediaTypes(messageConverter);
        return messageConverter;
    }

    public static void extensionSupportedMediaTypes(MappingJackson2HttpMessageConverter converter) {
        List<MediaType> supportedMediaTypes = Collects.concat(converter.getSupportedMediaTypes(), MediaType.TEXT_PLAIN, MediaType.TEXT_HTML, MediaType.MULTIPART_FORM_DATA);
        converter.setSupportedMediaTypes(supportedMediaTypes);
    }

    public static RestTemplate buildRestTemplate(int connectTimeout, int readTimeout, Charset charset, MappingJackson2HttpMessageConverter httpMessageConverter) {
        SSLContext sslContext;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(readTimeout);
        requestFactory.setHttpContextFactory((BiFunction)new HttpContextFactory());
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(charset), new ResourceHttpMessageConverter(), new SourceHttpMessageConverter(), new FormHttpMessageConverter(), httpMessageConverter));
        return restTemplate;
    }

    public static MultiValueMap<String, String> toMultiValueMap(Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        Map<String, List> map = params.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey())) && ObjectUtils.isNotEmpty(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> RestTemplateUtils.toListString(e.getValue())));
        return MapUtils.isEmpty(map) ? null : new LinkedMultiValueMap(map);
    }

    private static List<String> toListString(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                list.add(RestTemplateUtils.toString(Array.get(value, i)));
            }
            return list;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return coll.isEmpty() ? null : coll.stream().map(RestTemplateUtils::toString).collect(Collectors.toList());
        }
        return Collections.singletonList(RestTemplateUtils.toString(value));
    }

    private static String toString(Object value) {
        return value == null ? null : value.toString();
    }

    private static class HttpContextFactory
    implements BiFunction<HttpMethod, URI, HttpContext> {
        private HttpContextFactory() {
        }

        @Override
        public HttpContext apply(HttpMethod httpMethod, URI uri) {
            RequestConfig requestConfig = HttpContextHolder.get();
            if (requestConfig == null) {
                return null;
            }
            HttpClientContext context = HttpClientContext.create();
            context.setAttribute("http.request-config", (Object)requestConfig);
            return context;
        }
    }

    public static class HttpContextHolder {
        private static final ThreadLocal<RequestConfig> THREAD_LOCAL = new NamedThreadLocal("request-config");

        public static void bind(RequestConfig requestConfig) {
            THREAD_LOCAL.set(requestConfig);
        }

        private static RequestConfig get() {
            return THREAD_LOCAL.get();
        }

        public static void unbind() {
            THREAD_LOCAL.remove();
        }
    }
}

