/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.spring;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static final List<ApplicationContext> HOLDER = new ArrayList<ApplicationContext>();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContext(ApplicationContext cxt) throws BeansException {
        Class<SpringContextHolder> clazz = SpringContextHolder.class;
        synchronized (SpringContextHolder.class) {
            if (!HOLDER.contains(cxt)) {
                HOLDER.add(cxt);
            }
            INITIALIZED.compareAndSet(false, true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isInitialized() {
        return INITIALIZED.get();
    }

    public static Object getBean(String name) {
        return SpringContextHolder.get(c -> c.getBean(name));
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringContextHolder.get(c -> c.getBean(clazz));
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextHolder.get(c -> c.getBean(name, clazz));
    }

    public static boolean containsBean(String name) {
        for (ApplicationContext c : HOLDER) {
            if (!c.containsBean(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleton(String name) {
        BeansException ex = null;
        for (ApplicationContext c : HOLDER) {
            try {
                if (!c.isSingleton(name)) continue;
                return true;
            }
            catch (BeansException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex == null) {
            return false;
        }
        throw ex;
    }

    public static boolean isPrototype(String name) {
        BeansException ex = null;
        for (ApplicationContext c : HOLDER) {
            try {
                if (!c.isPrototype(name)) continue;
                return true;
            }
            catch (BeansException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex == null) {
            return false;
        }
        throw ex;
    }

    public static boolean isPrototype(Class<?> type) {
        for (ApplicationContext c : HOLDER) {
            Object[] beanNames = c.getBeanNamesForType(type);
            if (!ArrayUtils.isNotEmpty((Object[])beanNames)) continue;
            return Arrays.stream(beanNames).allMatch(arg_0 -> ((ApplicationContext)c).isPrototype(arg_0));
        }
        return false;
    }

    public static Class<?> getType(String name) {
        return SpringContextHolder.get(c -> c.getType(name));
    }

    public static String[] getAliases(String name) {
        return SpringContextHolder.get(c -> c.getAliases(name));
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return SpringContextHolder.get(c -> c.getBeansWithAnnotation(annotationType));
    }

    public static void autowire(Object object) {
        Assert.state((HOLDER.size() > 0 ? 1 : 0) != 0, (String)"Must be defined SpringContextHolder within spring config file.");
        for (ApplicationContext context : HOLDER) {
            context.getAutowireCapableBeanFactory().autowireBean(object);
        }
    }

    public void destroy() {
    }

    private static <T> T get(Function<ApplicationContext, T> finder) throws BeansException {
        BeansException ex = null;
        for (ApplicationContext c : HOLDER) {
            try {
                T result = finder.apply(c);
                if (result == null) continue;
                return result;
            }
            catch (BeansException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex == null) {
            return null;
        }
        throw ex;
    }
}

