/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.tree;

import cn.ponfee.scheduler.common.util.GenericUtils;
import cn.ponfee.scheduler.common.util.ImmutableArrayList;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

@JSONType(mappingTo=FastjsonDeserializeMarker.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public final class NodePath<T extends Serializable & Comparable<? super T>>
extends ImmutableArrayList<T>
implements Comparable<NodePath<T>> {
    private static final long serialVersionUID = 9090552044337950223L;

    public NodePath() {
    }

    @SafeVarargs
    public NodePath(T ... path) {
        super(path);
    }

    public NodePath(T[] parent, T child) {
        super(ArrayUtils.addAll((Object[])Objects.requireNonNull(parent), (Object[])new Serializable[]{child}));
    }

    public NodePath(List<T> path) {
        super(path.toArray());
    }

    public NodePath(List<T> path, T child) {
        super(ArrayUtils.addAll((Object[])path.toArray(), (Object[])new Object[]{child}));
    }

    public NodePath(NodePath<T> parent) {
        super(parent.toArray());
    }

    public NodePath(NodePath<T> parent, T child) {
        super(parent.join(child));
    }

    @Override
    public int compareTo(NodePath<T> o) {
        Iterator a = this.iterator();
        Iterator b = o.iterator();
        while (a.hasNext() && b.hasNext()) {
            int c = ((Comparable)((Object)((Serializable)a.next()))).compareTo(b.next());
            if (c == 0) continue;
            return c;
        }
        return super.size() - o.size();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NodePath && super.equals(obj);
    }

    @Override
    public NodePath<T> clone() {
        return new NodePath<T>(this);
    }

    public static class JacksonDeserializer<T extends Serializable & Comparable<? super T>>
    extends JsonDeserializer<NodePath<T>> {
        public NodePath<T> deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            List list = (List)p.readValueAs(List.class);
            return CollectionUtils.isEmpty((Collection)list) ? null : new NodePath(list);
        }
    }

    public static class FastjsonDeserializer<T extends Serializable & Comparable<? super T>>
    implements ObjectDeserializer {
        public NodePath<T> deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            if (GenericUtils.getRawType(type) != NodePath.class) {
                throw new UnsupportedOperationException("Only supported deserialize NodePath, cannot supported: " + type);
            }
            List list = parser.parseArray(GenericUtils.getActualTypeArgument(type, 0));
            return list.isEmpty() ? null : new NodePath(list);
        }

        public int getFastMatchToken() {
            return 0;
        }
    }

    @JSONType(deserializer=FastjsonDeserializer.class)
    public static class FastjsonDeserializeMarker {
    }
}

