/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.tuple;

import cn.ponfee.scheduler.common.base.DelegatedIntSpliterator;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Function;

public abstract class Tuple
implements Comparable<Object>,
Iterable<Object>,
Serializable {
    private static final long serialVersionUID = -3292038317953347997L;
    public static final int HASH_FACTOR = 31;

    public abstract <T> T get(int var1);

    public abstract <T> void set(T var1, int var2);

    public abstract Object[] toArray();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract <T> T copy();

    public abstract int length();

    public List<Object> toList() {
        return ImmutableList.copyOf((Object[])this.toArray());
    }

    @Override
    public Iterator<Object> iterator() {
        return new TupleIterator<Object>();
    }

    @Override
    public Spliterator<Object> spliterator() {
        return new DelegatedIntSpliterator<Object>(0, this.length(), this::get);
    }

    @Override
    public final int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof Tuple)) {
            return ObjectUtils.compare(this, o);
        }
        Tuple other = (Tuple)o;
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            int c = ObjectUtils.compare(this.get(i), other.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public final String join() {
        return this.join(", ", String::valueOf, "", "");
    }

    public final String join(CharSequence delimiter, Function<Object, String> valueMapper, CharSequence prefix, CharSequence suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        int n = this.length() - 1;
        for (int i = 0; i <= n; ++i) {
            builder.append(valueMapper.apply(this.get(i)));
            if (i >= n) continue;
            builder.append(delimiter);
        }
        return builder.append(suffix).toString();
    }

    private class TupleIterator<T>
    implements Iterator<T> {
        private int position = 0;
        private final int size = Tuple.this.length();

        private TupleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Tuple.this.get(this.position++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

