/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import cn.ponfee.scheduler.common.util.Numbers;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class Collects {
    public static <E> LinkedList<E> newLinkedList(E element) {
        LinkedList<E> list = new LinkedList<E>();
        list.add(element);
        return list;
    }

    public static <T> T[] toArray(T ... args) {
        return args;
    }

    public static <T> List<T> duplicate(Collection<T> list) {
        return Collects.duplicate(list, Function.identity());
    }

    public static <T, R> List<R> duplicate(Collection<T> list, Function<T, R> mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(mapper).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <T> T getFirst(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values instanceof Deque) {
            return (T)((Deque)values).getFirst();
        }
        if (values instanceof List) {
            return (T)((List)values).get(0);
        }
        return values.iterator().next();
    }

    public static <T> T getLast(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values instanceof Deque) {
            return (T)((Deque)values).getLast();
        }
        if (values instanceof List) {
            return (T)((List)values).get(values.size() - 1);
        }
        return values.stream().reduce((a, b) -> b).orElse(null);
    }

    public static <T> T get(T[] array, int index) {
        if (array == null || index < 0 || index >= array.length) {
            return null;
        }
        return index < array.length ? (T)array[index] : null;
    }

    public static <T> T get(List<T> list, int index) {
        if (list == null || index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public static List<int[]> partition(int[] array, int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Size must be greater than 0.");
        if (array == null || array.length == 0) {
            return null;
        }
        if ((size = Math.min(size, array.length)) == 1) {
            return Collections.singletonList(array);
        }
        ArrayList<int[]> result = new ArrayList<int[]>(size);
        int pos = 0;
        for (int number : Numbers.slice(array.length, size)) {
            if (number == 0) break;
            result.add(Arrays.copyOfRange(array, pos, pos += number));
        }
        return result;
    }

    public static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <S, T> List<T> convert(List<S> source, Function<S, T> mapper) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)source.size());
        source.stream().map(mapper).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> list, T ... array) {
        if (list == null) {
            return array == null ? Collections.emptyList() : Arrays.asList(array);
        }
        if (array == null || array.length == 0) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(list.size() + array.length);
        result.addAll(list);
        Collections.addAll(result, array);
        return result;
    }

    public static <T> T[] newArray(Class<? extends T[]> newType, int length) {
        return newType.equals(Object[].class) ? new Object[length] : (Object[])Array.newInstance(newType.getComponentType(), length);
    }
}

