/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import cn.ponfee.scheduler.common.util.ClassUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

public class ExtendMethodHandles {
    public static final Function<Class<?>, MethodHandles.Lookup> METHOD_LOOKUP;

    public static MethodHandle getSpecialMethodHandle(Method parentMethod) {
        Class<?> declaringClass = parentMethod.getDeclaringClass();
        MethodHandles.Lookup lookup = METHOD_LOOKUP.apply(declaringClass);
        try {
            return lookup.in(declaringClass).unreflectSpecial(parentMethod, declaringClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method java9PrivateLookupInMethod = ClassUtils.getMethod(MethodHandles.class, "privateLookupIn", Class.class, MethodHandles.Lookup.class);
        if (java9PrivateLookupInMethod != null) {
            METHOD_LOOKUP = callerClass -> {
                try {
                    return (MethodHandles.Lookup)java9PrivateLookupInMethod.invoke(MethodHandles.class, callerClass, MethodHandles.lookup());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        } else {
            final Constructor<MethodHandles.Lookup> java8LookupConstructor = ClassUtils.getConstructor(MethodHandles.Lookup.class, Class.class, Integer.TYPE);
            if (java8LookupConstructor == null) {
                throw new IllegalStateException("Not found 'privateLookupIn(Class, Lookup)' and 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.");
            }
            java8LookupConstructor.setAccessible(true);
            METHOD_LOOKUP = new Function<Class<?>, MethodHandles.Lookup>(){
                private static final int ALLOWED_MODES = 15;

                @Override
                public MethodHandles.Lookup apply(Class<?> callerClass) {
                    try {
                        return (MethodHandles.Lookup)java8LookupConstructor.newInstance(callerClass, 15);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("No found 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
                    }
                }
            };
        }
    }
}

