/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.common.util.SynchronizedCaches;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;

public final class GenericUtils {
    private static final Map<Class<?>, Map<String, Class<?>>> VARIABLE_TYPE_MAPPING = new HashMap();

    public static Map<String, String> covariant(Map<String, ?> origin) {
        if (origin == null) {
            return null;
        }
        HashMap<String, String> target = new HashMap<String, String>(origin.size());
        for (Map.Entry<String, ?> entry : origin.entrySet()) {
            target.put(entry.getKey(), Objects.toString(entry.getValue(), null));
        }
        return target;
    }

    public static Map<String, String> covariant(Properties properties) {
        return properties;
    }

    public static <T> Class<T> getActualTypeArgument(Class<?> clazz) {
        return GenericUtils.getActualTypeArgument(clazz, 0);
    }

    public static <T> Class<T> getActualTypeArgument(Class<?> clazz, int genericArgsIndex) {
        int index = 0;
        for (Type type : GenericUtils.getGenericTypes(clazz)) {
            if (!(type instanceof ParameterizedType)) continue;
            Type[] acts = ((ParameterizedType)type).getActualTypeArguments();
            if (acts.length + index < genericArgsIndex) {
                index += acts.length;
                continue;
            }
            return GenericUtils.getActualType(null, acts[genericArgsIndex - index]);
        }
        return Object.class;
    }

    public static <T> Class<T> getActualArgTypeArgument(Method method, int methodArgsIndex) {
        return GenericUtils.getActualArgTypeArgument(method, methodArgsIndex, 0);
    }

    public static <T> Class<T> getActualArgTypeArgument(Method method, int methodArgsIndex, int genericArgsIndex) {
        return GenericUtils.getActualTypeArgument(method.getGenericParameterTypes()[methodArgsIndex], genericArgsIndex);
    }

    public static <T> Class<T> getActualReturnTypeArgument(Method method) {
        return GenericUtils.getActualReturnTypeArgument(method, 0);
    }

    public static <T> Class<T> getActualReturnTypeArgument(Method method, int genericArgsIndex) {
        return GenericUtils.getActualTypeArgument(method.getGenericReturnType(), genericArgsIndex);
    }

    public static <T> Class<T> getActualTypeArgument(Field field) {
        return GenericUtils.getActualTypeArgument(field, 0);
    }

    public static <T> Class<T> getActualTypeArgument(Field field, int genericArgsIndex) {
        return GenericUtils.getActualTypeArgument(field.getGenericType(), genericArgsIndex);
    }

    public static <T> Class<T> getFieldActualType(Class<?> clazz, String fieldName) {
        Field field = ClassUtils.getField(clazz, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Type " + clazz + " not exists field '" + fieldName + "'");
        }
        return GenericUtils.getFieldActualType(clazz, field);
    }

    public static <T> Class<T> getFieldActualType(Class<?> clazz, Field field) {
        return Modifier.isStatic(field.getModifiers()) ? field.getType() : GenericUtils.getActualType(clazz, field.getGenericType());
    }

    public static <T> Class<T> getMethodArgActualType(Class<?> clazz, Method method, int methodArgsIndex) {
        return GenericUtils.getActualType(clazz, method.getGenericParameterTypes()[methodArgsIndex]);
    }

    public static <T> Class<T> getMethodReturnActualType(Class<?> clazz, Method method) {
        return GenericUtils.getActualType(clazz, method.getGenericReturnType());
    }

    public static List<Type> getGenericTypes(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList<Type> types = new ArrayList<Type>();
        if (!clazz.isInterface()) {
            types.add(clazz.getGenericSuperclass());
        }
        Collections.addAll(types, clazz.getGenericInterfaces());
        return types;
    }

    public static Map<String, Class<?>> getActualTypeVariableMapping(Class<?> clazz) {
        HashMap result = new HashMap();
        for (Type type : GenericUtils.getGenericTypes(clazz)) {
            GenericUtils.resolveMapping(result, type);
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static <T> Class<T> getActualTypeArgument(Type type, int genericArgsIndex) {
        Preconditions.checkArgument((genericArgsIndex >= 0 ? 1 : 0) != 0, (Object)"Generic args index cannot be negative.");
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return genericArgsIndex >= types.length ? Object.class : GenericUtils.getActualType(null, types[genericArgsIndex]);
    }

    private static <T> Class<T> getActualType(Class<?> clazz, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericUtils.getActualType(clazz, ((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type etype = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(GenericUtils.getActualType(clazz, etype), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return GenericUtils.getVariableActualType(clazz, (TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wtype = (WildcardType)type;
            if (ArrayUtils.isNotEmpty((Object[])wtype.getLowerBounds())) {
                return GenericUtils.getActualType(clazz, wtype.getLowerBounds()[0]);
            }
            if (ArrayUtils.isNotEmpty((Object[])wtype.getUpperBounds())) {
                return GenericUtils.getActualType(clazz, wtype.getUpperBounds()[0]);
            }
            return Object.class;
        }
        return Object.class;
    }

    private static <T> Class<T> getVariableActualType(Class<?> clazz, TypeVariable<?> var) {
        if (clazz == null) {
            return Object.class;
        }
        return SynchronizedCaches.get(clazz, VARIABLE_TYPE_MAPPING, GenericUtils::getActualTypeVariableMapping).getOrDefault(GenericUtils.getTypeVariableName(null, var).get(0), Object.class);
    }

    private static void resolveMapping(Map<String, Class<?>> result, Type type) {
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType ptype = (ParameterizedType)type;
        Class rawType = (Class)ptype.getRawType();
        TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
        Type[] acts = ptype.getActualTypeArguments();
        for (int i = 0; i < acts.length; ++i) {
            Class varType = GenericUtils.getActualType(null, acts[i]);
            GenericUtils.getTypeVariableName(rawType, vars[i]).forEach(e -> result.put((String)e, varType));
            GenericUtils.resolveMapping(result, acts[i]);
        }
    }

    private static List<String> getTypeVariableName(Class<?> clazz, TypeVariable<?> var) {
        ArrayList<String> names = new ArrayList<String>();
        GenericUtils.getTypeVariableName(names, clazz, var);
        return names;
    }

    private static void getTypeVariableName(List<String> names, Class<?> clazz, TypeVariable<?> var) {
        names.add(var.getGenericDeclaration().toString() + "[" + var.getName() + "]");
        if (clazz == null || clazz == Object.class) {
            return;
        }
        block0: for (Type type : GenericUtils.getGenericTypes(clazz)) {
            ParameterizedType ptype;
            Object[] types;
            if (!(type instanceof ParameterizedType) || ArrayUtils.isEmpty((Object[])(types = (ptype = (ParameterizedType)type).getActualTypeArguments()))) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!(types[i] instanceof TypeVariable) || !((TypeVariable)types[i]).getName().equals(var.getTypeName())) continue;
                clazz = (Class)ptype.getRawType();
                GenericUtils.getTypeVariableName(names, clazz, clazz.getTypeParameters()[i]);
                continue block0;
            }
        }
    }
}

