/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import cn.ponfee.scheduler.common.util.CRC16;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;

public class ConsistentHash<T> {
    private final TreeMap<Integer, VirtualNode> ring = new TreeMap();
    private final Function<T, String> keyMapper;
    private final HashFunction hashFunction;

    public ConsistentHash(Collection<T> pNodes, int vNodeCount) {
        this(pNodes, vNodeCount, String::valueOf, HashFunction.MD5);
    }

    public ConsistentHash(Collection<T> pNodes, int vNodeCount, Function<T, String> keyMapper) {
        this(pNodes, vNodeCount, keyMapper, HashFunction.MD5);
    }

    public ConsistentHash(Collection<T> pNodes, int vNodeCount, Function<T, String> keyMapper, HashFunction hashFunction) {
        if (keyMapper == null) {
            throw new NullPointerException("Key mapper is null.");
        }
        if (hashFunction == null) {
            throw new NullPointerException("Hash function is null.");
        }
        this.keyMapper = keyMapper;
        this.hashFunction = hashFunction;
        if (pNodes != null) {
            for (T pNode : pNodes) {
                this.addNode(pNode, vNodeCount);
            }
        }
    }

    public void addNode(T pNode, int vNodeCount) {
        if (vNodeCount < 0) {
            throw new IllegalArgumentException("Invalid virtual node counts :" + vNodeCount);
        }
        int existingReplicas = this.getExistingReplicas(pNode);
        for (int i = 0; i < vNodeCount; ++i) {
            VirtualNode vNode = new VirtualNode(pNode, i + existingReplicas);
            this.ring.put(this.hashFunction.hash(vNode.virtualKey), vNode);
        }
    }

    public void removeNode(T pNode) {
        Iterator<Integer> it = this.ring.keySet().iterator();
        while (it.hasNext()) {
            Integer key = it.next();
            VirtualNode virtualNode = this.ring.get(key);
            if (!virtualNode.isVirtualNodeOf(pNode)) continue;
            it.remove();
        }
    }

    public T routeNode(String key) {
        if (this.ring.isEmpty()) {
            return null;
        }
        SortedMap<Integer, VirtualNode> tailMap = this.ring.tailMap(this.hashFunction.hash(key));
        VirtualNode virtualNode = tailMap.isEmpty() ? this.ring.firstEntry().getValue() : this.ring.get(tailMap.firstKey());
        return (T)virtualNode.physicalNode;
    }

    public int getExistingReplicas(T pNode) {
        return (int)this.ring.entrySet().stream().filter(e -> ((VirtualNode)e.getValue()).isVirtualNodeOf(pNode)).count();
    }

    private class VirtualNode {
        private final T physicalNode;
        private final String physicalKey;
        private final String virtualKey;

        private VirtualNode(T physicalNode, int replicaIndex) {
            this.physicalNode = physicalNode;
            this.physicalKey = (String)ConsistentHash.this.keyMapper.apply(physicalNode);
            this.virtualKey = "SHARD-" + this.physicalKey + "-NODE-" + replicaIndex;
        }

        private boolean isVirtualNodeOf(T pNode) {
            return this.physicalKey.equals(ConsistentHash.this.keyMapper.apply(pNode));
        }
    }

    @FunctionalInterface
    public static interface HashFunction {
        public static final HashFunction MD5;
        public static final HashFunction FNV;
        public static final HashFunction CRC16;

        public int hash(String var1);

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
            MD5 = key -> {
                byte[] digest = DigestUtils.md5((String)key);
                if (!1.$assertionsDisabled && digest.length != 16) {
                    throw new AssertionError();
                }
                int hash = 0;
                int i = 15;
                while (i >= 3) {
                    int h = (digest[i--] & 0xFF) << 24 | (digest[i--] & 0xFF) << 16 | (digest[i--] & 0xFF) << 8 | digest[i--] & 0xFF;
                    hash = i == 11 ? h : hash ^ h;
                }
                return hash;
            };
            FNV = key -> {
                int p = 16777619;
                int h = -2128831035;
                for (int i = 0; i < key.length(); ++i) {
                    h = (h ^ key.charAt(i)) * p;
                }
                h += h << 13;
                h ^= h >> 7;
                h += h << 3;
                h ^= h >> 17;
                h += h << 5;
                return h;
            };
            CRC16 = key -> cn.ponfee.scheduler.common.util.CRC16.digest(key.getBytes(StandardCharsets.UTF_8));
        }
    }
}

