/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class TimingWheel<T extends Timing<T>>
implements Serializable {
    private static final long serialVersionUID = 4500377208898808026L;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MILLIS_PER_MINUTE = 60000;
    private final TimingQueue<T>[] ringBuffer;

    public TimingWheel() {
        this(11);
    }

    public TimingWheel(int priorityQueueInitialCapacity) {
        TimingQueue[] array = new TimingQueue[60];
        for (int i = 0; i < 60; ++i) {
            array[i] = new TimingQueue(priorityQueueInitialCapacity);
        }
        this.ringBuffer = array;
    }

    protected boolean verify(T timing) {
        return true;
    }

    public final boolean offer(T timing) {
        return this.offer(timing, System.currentTimeMillis() + 1099L);
    }

    public final boolean offer(T timing, long leastTimeMillis) {
        if (!this.verify(timing)) {
            return false;
        }
        long slotTimeMillis = Math.max(timing.timing(), leastTimeMillis);
        int ringSecond = TimingWheel.secondOfMinute(slotTimeMillis);
        return this.ringBuffer[ringSecond].offer(timing);
    }

    public final List<T> poll() {
        return this.poll(System.currentTimeMillis());
    }

    public final List<T> poll(long latestTimeMillis) {
        ArrayList<T> ringTrigger = new ArrayList<T>();
        int ringSecond = TimingWheel.secondOfMinute(latestTimeMillis);
        long maximumTiming = latestTimeMillis / 1000L * 1000L + 999L;
        block0: for (int i = 0; i < 2; ++i) {
            T first;
            TimingQueue<T> ringTick = this.ringBuffer[(ringSecond - i + 60) % 60];
            while ((first = ringTick.peek()) != null && first.timing() <= maximumTiming && (first = ringTick.poll()) != null) {
                if (first.timing() > maximumTiming) {
                    ringTick.offer(first);
                    continue block0;
                }
                ringTrigger.add(first);
            }
        }
        return ringTrigger;
    }

    private static int secondOfMinute(long timeMillis) {
        return (int)(timeMillis % 60000L / 1000L);
    }

    public static final class TimingQueue<T extends Timing<T>> {
        private final PriorityQueue<T> queue;

        public TimingQueue() {
            this.queue = new PriorityQueue();
        }

        public TimingQueue(int initialCapacity) {
            this.queue = new PriorityQueue(initialCapacity);
        }

        public synchronized T poll() {
            return (T)((Timing)this.queue.poll());
        }

        public synchronized boolean offer(T timing) {
            return this.queue.offer(timing);
        }

        public T peek() {
            return (T)((Timing)this.queue.peek());
        }

        public int size() {
            return this.queue.size();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    public static interface Timing<T extends Timing<T>>
    extends Comparable<T> {
        public long timing();

        @Override
        default public int compareTo(T other) {
            return Long.compare(this.timing(), other.timing());
        }
    }
}

