/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;

public class LazyLoader<T>
implements Supplier<T> {
    private final Supplier<T> loader;
    private Optional<T> holder;

    private LazyLoader(Supplier<T> loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    public static <T> LazyLoader<T> of(Supplier<T> loader) {
        return new LazyLoader<T>(loader);
    }

    public static <T, B extends T, C extends T> B of(Class<T> type, Supplier<C> loader) {
        return LazyLoader.of(type, LazyLoader.of(loader));
    }

    public static <T, A> LazyLoader<T> of(Function<A, T> loader, A arg) {
        return new LazyLoader<Object>(() -> loader.apply(arg));
    }

    public static <T, A, B extends T, C extends T> B of(Class<T> type, Function<A, C> loader, A arg) {
        return LazyLoader.of(type, LazyLoader.of(loader, arg));
    }

    @Override
    public T get() {
        return this.holder().get();
    }

    public void orElse(T defaultValue) {
        this.holder().orElse(defaultValue);
    }

    public void orElseGet(Supplier<? extends T> other) {
        this.holder().orElseGet(other);
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.holder().ifPresent(consumer);
    }

    private Optional<T> holder() {
        if (this.holder == null) {
            this.holder = Optional.ofNullable(this.loader.get());
        }
        return this.holder;
    }

    private static <T, B extends T, C extends T> B of(Class<T> type, LazyLoader<C> lazyLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setUseCache(true);
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallback((Callback)((InvocationHandler)(beanProxy, method, args) -> method.invoke(lazyLoader.get(), args)));
        return (B)enhancer.create();
    }
}

