/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base.exception;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Throwables {
    private static final Logger LOG = LoggerFactory.getLogger(Throwables.class);

    public static String getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = list.size() - 1; i >= 0; --i) {
            String message = ((Throwable)list.get(i)).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            return "error: " + message;
        }
        return "error: <" + ClassUtils.getName(throwable.getClass()) + ">";
    }

    public static void ignore(Throwable ignored) {
        Throwables.ignore(ignored, true);
    }

    public static void ignore(Throwable ignored, boolean console) {
        if (console) {
            Throwables.console(ignored);
        }
    }

    public static void console(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static void checked(Throwable throwable) {
        Throwables.checked(throwable, null);
    }

    public static void checked(Throwable throwable, String msg) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (msg != null) {
            throw new RuntimeException(msg, throwable);
        }
        throw new RuntimeException(throwable);
    }

    public static void caught(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                if (!(t instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <R> R caught(Supplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
    }

    public static <E> void caught(Consumer<E> consumer, E arg) {
        block2: {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                if (!(t instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E, R> R caught(Function<E, R> function, E arg) {
        return Throwables.caught(function, arg, null);
    }

    public static <E, R> R caught(Function<E, R> function, E arg, R defaultValue) {
        try {
            return function.apply(arg);
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return defaultValue;
        }
    }
}

