/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.lock;

import cn.ponfee.scheduler.common.util.Numbers;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.Assert;

public class RedisLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7019337086720416828L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisLock.class);
    private static final String SET_SUCCESS = "OK";
    private static final long UNLOCK_SUCCESS = 1L;
    private static final int MAX_TIMEOUT_MILLIS = 86400000;
    private static final int DEFAULT_TIMEOUT_MILLIS = 300000;
    private static final int MIN_TIMEOUT_MILLIS = 9;
    private static final int MIN_SLEEP_MILLIS = 9;
    private static final String NX = "NX";
    private static final String PX = "PX";
    private static final String UNLOCK_SCRIPT_LUA = "if redis.call('get',KEYS[1])==ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end";
    private static final byte[] NX_BYTES = "NX".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PX_BYTES = "PX".getBytes(StandardCharsets.UTF_8);
    private static final RedisScript<Long> UNLOCK_SCRIPT_OBJECT = new DefaultRedisScript("if redis.call('get',KEYS[1])==ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end", Long.class);
    private static final String UNLOCK_SCRIPT_SHA1 = UNLOCK_SCRIPT_OBJECT.getSha1();
    private static final byte[] UNLOCK_SCRIPT_BYTES = UNLOCK_SCRIPT_OBJECT.getScriptAsString().getBytes(StandardCharsets.UTF_8);
    private static final ThreadLocal<byte[]> LOCK_VALUE = new ThreadLocal();
    private final transient RedisTemplate<?, ?> redisTemplate;
    private final byte[] lockKey;
    private final byte[] timeoutMillis;
    private final long sleepMillis;

    public RedisLock(RedisTemplate<?, ?> redisTemplate, String lockKey) {
        this(redisTemplate, lockKey, 300000);
    }

    public RedisLock(RedisTemplate<?, ?> redisTemplate, String lockKey, int timeoutMillis) {
        this(redisTemplate, lockKey, timeoutMillis, 9);
    }

    public RedisLock(RedisTemplate<?, ?> redisTemplate, String lockKey, int timeoutMillis, int sleepMillis) {
        Assert.notNull(redisTemplate, (String)"Redis template cannot be null.");
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)lockKey), (String)"Lock key cannot be empty.");
        this.redisTemplate = redisTemplate;
        this.lockKey = ("lock:" + lockKey).getBytes(StandardCharsets.UTF_8);
        timeoutMillis = Numbers.bound(timeoutMillis, 9, 86400000);
        this.timeoutMillis = Long.toString(timeoutMillis).getBytes(StandardCharsets.UTF_8);
        this.sleepMillis = Numbers.bound(sleepMillis, 9, timeoutMillis);
    }

    @Override
    public void lock() {
        int round = 0;
        while (!this.acquire()) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.computeSleepMillis(round));
            }
            catch (InterruptedException e) {
                LOG.error("Redis lock sleep occur interrupted exception.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            ++round;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        int round = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.acquire()) break;
            TimeUnit.MILLISECONDS.sleep(this.computeSleepMillis(round));
            ++round;
        }
    }

    @Override
    public boolean tryLock() {
        return this.acquire();
    }

    @Override
    public boolean tryLock(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        long end = System.nanoTime() + unit.toNanos(timeout);
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.acquire()) {
                return true;
            }
            if (end < System.nanoTime()) {
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(this.sleepMillis);
        }
    }

    @Override
    public void unlock() {
        this.release();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Unsupported new condition operation.");
    }

    public boolean isHeldByCurrentThread() {
        byte[] value = LOCK_VALUE.get();
        if (value == null) {
            return false;
        }
        return Arrays.equals(value, (byte[])this.redisTemplate.execute(conn -> conn.get(this.lockKey)));
    }

    public boolean isLocked() {
        Boolean res = (Boolean)this.redisTemplate.execute(conn -> conn.exists(this.lockKey));
        return res != null && res != false;
    }

    public void funlock() {
        this.redisTemplate.execute(conn -> conn.del((byte[][])new byte[][]{this.lockKey}));
    }

    private boolean acquire() {
        byte[] lockValue = ObjectUtils.uuid();
        Boolean res = (Boolean)this.redisTemplate.execute(conn -> {
            String ret = (String)conn.execute("SET", (byte[][])new byte[][]{this.lockKey, lockValue, NX_BYTES, PX_BYTES, this.timeoutMillis});
            boolean status = SET_SUCCESS.equals(ret);
            if (status) {
                LOCK_VALUE.set(lockValue);
            }
            return status;
        });
        return res != null && res != false;
    }

    private boolean release() {
        byte[] lockValue = LOCK_VALUE.get();
        if (lockValue == null) {
            return true;
        }
        byte[][] keysAndArgs = new byte[][]{this.lockKey, lockValue};
        Boolean res = (Boolean)this.redisTemplate.execute(conn -> {
            Long ret;
            if (conn.isPipelined() || conn.isQueueing()) {
                conn.eval(UNLOCK_SCRIPT_BYTES, ReturnType.INTEGER, 1, keysAndArgs);
                return false;
            }
            try {
                ret = (Long)conn.evalSha(UNLOCK_SCRIPT_SHA1, ReturnType.INTEGER, 1, keysAndArgs);
            }
            catch (Exception e) {
                if (RedisLock.exceptionContainsNoScriptError(e)) {
                    LOG.info(e.getMessage());
                    ret = (Long)conn.eval(UNLOCK_SCRIPT_BYTES, ReturnType.INTEGER, 1, keysAndArgs);
                }
                throw e instanceof RuntimeException ? (RuntimeException)e : new RedisSystemException(e.getMessage(), (Throwable)e);
            }
            return ret != null && ret == 1L;
        });
        LOCK_VALUE.remove();
        return res != null && res != false;
    }

    public static boolean exceptionContainsNoScriptError(Throwable e) {
        if (!(e instanceof NonTransientDataAccessException)) {
            return false;
        }
        for (Throwable current = e; current != null; current = current.getCause()) {
            String exMessage = current.getMessage();
            if (exMessage == null || !exMessage.contains("NOSCRIPT")) continue;
            return true;
        }
        return false;
    }

    private long computeSleepMillis(int round) {
        return round < 15 ? this.sleepMillis : Math.min(this.sleepMillis * 30L, 300L);
    }
}

