/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.springframework.util.Assert;

public abstract class TimingWheel<T extends Timing<T>>
implements Serializable {
    private static final long serialVersionUID = 4500377208898808026L;
    private static final int PROCESS_SLOTS_SIZE = 2;
    private final long tickMs;
    private final long msPerRound;
    private final TimingQueue<T>[] wheel;

    public TimingWheel(long tickMs, int ringSize) {
        Assert.isTrue((tickMs > 0L ? 1 : 0) != 0, (String)"Tick milliseconds must be greater than 0");
        Assert.isTrue((ringSize > 0 ? 1 : 0) != 0, (String)"Ring size must be greater than 0");
        this.tickMs = tickMs;
        this.msPerRound = tickMs * (long)ringSize;
        TimingQueue[] array = new TimingQueue[ringSize];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new TimingQueue();
        }
        this.wheel = array;
    }

    public final long getTickMs() {
        return this.tickMs;
    }

    public final int getRingSize() {
        return this.wheel.length;
    }

    protected boolean verify(T timing) {
        return true;
    }

    public final boolean offer(T timing) {
        return this.offer(timing, System.currentTimeMillis() + this.tickMs);
    }

    public final boolean offer(T timing, long leastTimeMillis) {
        if (!this.verify(timing)) {
            return false;
        }
        long slotTimeMillis = Math.max(timing.timing(), leastTimeMillis);
        int ringIndex = this.calculateIndex(slotTimeMillis);
        return this.wheel[ringIndex].offer(timing);
    }

    public final List<T> poll() {
        return this.poll(System.currentTimeMillis());
    }

    public final List<T> poll(long latestTimeMillis) {
        ArrayList<T> ringTrigger = new ArrayList<T>();
        int ringIndex = this.calculateIndex(latestTimeMillis);
        long maximumTiming = latestTimeMillis / this.tickMs * this.tickMs + this.tickMs;
        block0: for (int i = 0; i < 2; ++i) {
            T first;
            TimingQueue<T> ringTick = this.wheel[(ringIndex - i + this.wheel.length) % this.wheel.length];
            while ((first = ringTick.peek()) != null && first.timing() < maximumTiming && (first = ringTick.poll()) != null) {
                if (first.timing() > maximumTiming) {
                    ringTick.offer(first);
                    continue block0;
                }
                ringTrigger.add(first);
            }
        }
        return ringTrigger;
    }

    private int calculateIndex(long timeMillis) {
        return (int)(timeMillis % this.msPerRound / this.tickMs);
    }

    public static final class TimingQueue<T extends Timing<T>> {
        private final PriorityQueue<T> queue = new PriorityQueue();

        public synchronized T poll() {
            return (T)((Timing)this.queue.poll());
        }

        public synchronized boolean offer(T timing) {
            return this.queue.offer(timing);
        }

        public T peek() {
            return (T)((Timing)this.queue.peek());
        }

        public int size() {
            return this.queue.size();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    public static interface Timing<T extends Timing<T>>
    extends Comparable<T> {
        public long timing();

        @Override
        default public int compareTo(T other) {
            return Long.compare(this.timing(), other.timing());
        }
    }
}

