/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.spring;

import cn.ponfee.scheduler.common.base.TypedMap;
import cn.ponfee.scheduler.common.spring.YamlPropertySourceFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class YamlProperties
extends Properties
implements TypedMap<Object, Object> {
    private static final long serialVersionUID = -1599483902442715272L;

    public YamlProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.loadYaml(inputStream);
        }
    }

    public YamlProperties(InputStream inputStream) {
        this.loadYaml(inputStream);
    }

    public YamlProperties(String content) {
        this.loadYaml(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    private void loadYaml(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        super.putAll((Map<?, ?>)YamlPropertySourceFactory.loadYml((Resource)resource));
    }
}

