/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import cn.ponfee.scheduler.common.util.Numbers;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import org.springframework.util.Assert;

public class Collects {
    public static <T> T getFirst(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)(list instanceof Deque ? ((Deque)((Object)list)).getFirst() : list.get(0));
    }

    public static <T> T getLast(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)(list instanceof Deque ? ((Deque)((Object)list)).getLast() : list.get(list.size() - 1));
    }

    public static <T> T get(T[] array, int index) {
        if (array == null) {
            return null;
        }
        return index < array.length ? (T)array[index] : null;
    }

    public static <T> T get(List<T> list, int index) {
        if (list == null) {
            return null;
        }
        return index < list.size() ? (T)list.get(index) : null;
    }

    public static List<int[]> partition(int[] array, int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Size must be greater than 0.");
        if (array == null || array.length == 0) {
            return null;
        }
        if ((size = Math.min(size, array.length)) == 1) {
            return Collections.singletonList(array);
        }
        ArrayList<int[]> result = new ArrayList<int[]>(size);
        int pos = 0;
        for (int number : Numbers.slice(array.length, size)) {
            if (number == 0) break;
            result.add(Arrays.copyOfRange(array, pos, pos += number));
        }
        return result;
    }

    public static <S, T> List<T> convert(List<S> source, Function<S, T> mapper) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)source.size());
        source.stream().map(mapper).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> list, T ... array) {
        if (list == null) {
            return array == null ? Collections.emptyList() : Arrays.asList(array);
        }
        if (array == null || array.length == 0) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(list.size() + array.length);
        result.addAll(list);
        Collections.addAll(result, array);
        return result;
    }

    public static <T> T[] newArray(Class<? extends T[]> newType, int length) {
        return newType.equals(Object[].class) ? new Object[length] : (Object[])Array.newInstance(newType.getComponentType(), length);
    }
}

