/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.consul.configuration;

import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.registry.configuration.MarkServerRegistryAutoConfiguration;
import cn.ponfee.scheduler.registry.consul.ConsulSupervisorRegistry;
import cn.ponfee.scheduler.registry.consul.ConsulWorkerRegistry;
import cn.ponfee.scheduler.registry.consul.configuration.ConsulRegistryProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ConsulRegistryProperties.class})
public class ConsulServerRegistryAutoConfiguration
extends MarkServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.class})
    @ConditionalOnMissingBean
    @Bean
    public SupervisorRegistry supervisorRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, ConsulRegistryProperties config) {
        return new ConsulSupervisorRegistry(namespace, config);
    }

    @ConditionalOnBean(value={Worker.class})
    @ConditionalOnMissingBean
    @Bean
    public WorkerRegistry workerRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, ConsulRegistryProperties config) {
        return new ConsulWorkerRegistry(namespace, config);
    }
}

