/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.nacos;

import cn.ponfee.scheduler.common.base.exception.CheckedThrowing;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.registry.ServerRegistry;
import cn.ponfee.scheduler.registry.ServerRole;
import cn.ponfee.scheduler.registry.nacos.configuration.NacosRegistryProperties;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class NacosServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private final String groupName;
    private final NamingService namingService;
    private final EventListener eventListener;

    protected NacosServerRegistry(NacosRegistryProperties config) {
        super(config.getNamespace(), ':');
        this.groupName = StringUtils.isBlank((CharSequence)config.getNamespace()) ? "DEFAULT_GROUP" : config.getNamespace().trim();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.namingService = NacosFactory.createNamingService((Properties)config.toProperties());
            this.eventListener = event -> {
                CheckedThrowing.caught(() -> latch.await());
                if (event instanceof NamingEvent) {
                    this.doRefreshDiscoveryServers(((NamingEvent)event).getInstances());
                }
            };
            this.namingService.subscribe(this.discoveryRootPath, this.groupName, this.eventListener);
            this.doRefreshDiscoveryServers(this.namingService.selectInstances(this.discoveryRootPath, this.groupName, true));
        }
        catch (NacosException e) {
            throw new IllegalStateException(e);
        }
        finally {
            latch.countDown();
        }
    }

    public final boolean isConnected() {
        return "UP".equals(this.namingService.getServerStatus());
    }

    public final void register(R server) {
        if (this.closed.get()) {
            return;
        }
        Instance instance = this.createInstance(server);
        try {
            this.namingService.registerInstance(this.registryRootPath, this.groupName, instance);
            this.registered.add(server);
            this.log.info("Nacos server registered: {} | {}", (Object)this.registryRole.name(), server);
        }
        catch (Throwable e) {
            throw new RuntimeException("Nacos server registered failed: " + server, e);
        }
    }

    public final void deregister(R server) {
        Instance instance = this.createInstance(server);
        try {
            this.registered.remove(server);
            this.namingService.deregisterInstance(this.registryRootPath, this.groupName, instance);
            this.log.info("Nacos server deregister: {} | {}", (Object)this.registryRole.name(), server);
        }
        catch (Exception e) {
            this.log.error("Nacos server deregister error.", (Throwable)e);
        }
    }

    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            this.log.warn("Repeat call close method\n{}", (Object)ObjectUtils.getStackTrace());
            return;
        }
        CheckedThrowing.caught(() -> this.namingService.unsubscribe(this.discoveryRootPath, this.groupName, this.eventListener));
        this.registered.forEach(this::deregister);
        this.registered.clear();
        CheckedThrowing.caught(() -> ((NamingService)this.namingService).shutDown());
        super.close();
    }

    private Instance createInstance(R server) {
        Instance instance = new Instance();
        instance.setInstanceId(server.serialize());
        instance.setIp(server.getHost());
        instance.setPort(server.getPort());
        return instance;
    }

    private synchronized void doRefreshDiscoveryServers(List<Instance> instances) {
        List servers;
        if (CollectionUtils.isEmpty(instances)) {
            this.log.error("Not discovered available {} from nacos.", (Object)this.discoveryRole.name());
            servers = Collections.emptyList();
        } else {
            servers = instances.stream().map(Instance::getInstanceId).filter(Objects::nonNull).map(arg_0 -> ((ServerRole)this.discoveryRole).deserialize(arg_0)).collect(Collectors.toList());
        }
        this.refreshDiscoveredServers(servers);
    }
}

