/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.nacos.configuration;

import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.registry.configuration.MarkServerRegistryAutoConfiguration;
import cn.ponfee.scheduler.registry.nacos.NacosSupervisorRegistry;
import cn.ponfee.scheduler.registry.nacos.NacosWorkerRegistry;
import cn.ponfee.scheduler.registry.nacos.configuration.NacosRegistryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NacosRegistryProperties.class})
public class NacosServerRegistryAutoConfiguration
extends MarkServerRegistryAutoConfiguration {
    @ConditionalOnBean(value={Supervisor.class})
    @ConditionalOnMissingBean
    @Bean
    public SupervisorRegistry supervisorRegistry(NacosRegistryProperties config) {
        return new NacosSupervisorRegistry(config);
    }

    @ConditionalOnBean(value={Worker.class})
    @ConditionalOnMissingBean
    @Bean
    public WorkerRegistry workerRegistry(NacosRegistryProperties config) {
        return new NacosWorkerRegistry(config);
    }
}

