/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor;

import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.configuration.SupervisorProperties;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import cn.ponfee.scheduler.supervisor.thread.RunningInstanceScanner;
import cn.ponfee.scheduler.supervisor.thread.TriggeringJobScanner;
import cn.ponfee.scheduler.supervisor.thread.WaitingInstanceScanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class SupervisorStartup
implements AutoCloseable {
    private final Supervisor currentSupervisor;
    private final TriggeringJobScanner triggeringJobScanner;
    private final WaitingInstanceScanner waitingInstanceScanner;
    private final RunningInstanceScanner runningInstanceScanner;
    private final TaskDispatcher taskDispatcher;
    private final SupervisorRegistry supervisorRegistry;
    private final AtomicBoolean started = new AtomicBoolean(false);

    private SupervisorStartup(Supervisor currentSupervisor, SupervisorProperties supervisorConfig, SupervisorRegistry supervisorRegistry, SchedulerJobManager schedulerJobManager, DoInLocked scanTriggeringJobLocker, DoInLocked scanWaitingInstanceLocker, DoInLocked scanRunningInstanceLocker, TaskDispatcher taskDispatcher) {
        Assert.notNull((Object)currentSupervisor, (String)"Current supervisor cannot null.");
        Assert.notNull((Object)supervisorConfig, (String)"Supervisor config cannot null.");
        Assert.notNull((Object)supervisorRegistry, (String)"Supervisor registry cannot null.");
        Assert.notNull((Object)schedulerJobManager, (String)"Scheduler job manager cannot null.");
        Assert.notNull((Object)scanTriggeringJobLocker, (String)"Scan triggering job locker cannot null.");
        Assert.notNull((Object)scanWaitingInstanceLocker, (String)"Scan waiting instance locker cannot null.");
        Assert.notNull((Object)scanRunningInstanceLocker, (String)"Scan running instance locker cannot null.");
        Assert.notNull((Object)taskDispatcher, (String)"Task dispatcher cannot null.");
        supervisorConfig.check();
        this.currentSupervisor = currentSupervisor;
        this.supervisorRegistry = supervisorRegistry;
        this.triggeringJobScanner = new TriggeringJobScanner(supervisorConfig.getScanTriggeringJobPeriodMs(), scanTriggeringJobLocker, schedulerJobManager);
        this.waitingInstanceScanner = new WaitingInstanceScanner(supervisorConfig.getScanWaitingInstancePeriodMs(), scanWaitingInstanceLocker, schedulerJobManager);
        this.runningInstanceScanner = new RunningInstanceScanner(supervisorConfig.getScanRunningInstancePeriodMs(), scanRunningInstanceLocker, schedulerJobManager);
        this.taskDispatcher = taskDispatcher;
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.triggeringJobScanner.start();
        this.waitingInstanceScanner.start();
        this.runningInstanceScanner.start();
        this.supervisorRegistry.register((Server)this.currentSupervisor);
    }

    @Override
    public void close() {
        Throwables.caught(() -> ((SupervisorRegistry)this.supervisorRegistry).close());
        Throwables.caught(() -> ((RunningInstanceScanner)this.runningInstanceScanner).toStop());
        Throwables.caught(() -> ((WaitingInstanceScanner)this.waitingInstanceScanner).toStop());
        Throwables.caught(() -> ((TriggeringJobScanner)this.triggeringJobScanner).toStop());
        Throwables.caught(() -> ((TaskDispatcher)this.taskDispatcher).close());
        Throwables.caught(() -> this.runningInstanceScanner.doStop(1000L));
        Throwables.caught(() -> this.waitingInstanceScanner.doStop(1000L));
        Throwables.caught(() -> this.triggeringJobScanner.doStop(1000L));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supervisor currentSupervisor;
        private SupervisorProperties supervisorConfig;
        private SupervisorRegistry supervisorRegistry;
        private SchedulerJobManager schedulerJobManager;
        private DoInLocked scanTriggeringJobLocker;
        private DoInLocked scanWaitingInstanceLocker;
        private DoInLocked scanRunningInstanceLocker;
        private TaskDispatcher taskDispatcher;

        private Builder() {
        }

        public Builder currentSupervisor(Supervisor currentSupervisor) {
            this.currentSupervisor = currentSupervisor;
            return this;
        }

        public Builder supervisorConfig(SupervisorProperties supervisorConfig) {
            this.supervisorConfig = supervisorConfig;
            return this;
        }

        public Builder supervisorRegistry(SupervisorRegistry supervisorRegistry) {
            this.supervisorRegistry = supervisorRegistry;
            return this;
        }

        public Builder schedulerJobManager(SchedulerJobManager schedulerJobManager) {
            this.schedulerJobManager = schedulerJobManager;
            return this;
        }

        public Builder scanTriggeringJobLocker(DoInLocked scanTriggeringJobLocker) {
            this.scanTriggeringJobLocker = scanTriggeringJobLocker;
            return this;
        }

        public Builder scanWaitingInstanceLocker(DoInLocked scanWaitingInstanceLocker) {
            this.scanWaitingInstanceLocker = scanWaitingInstanceLocker;
            return this;
        }

        public Builder scanRunningInstanceLocker(DoInLocked scanRunningInstanceLocker) {
            this.scanRunningInstanceLocker = scanRunningInstanceLocker;
            return this;
        }

        public Builder taskDispatcher(TaskDispatcher taskDispatcher) {
            this.taskDispatcher = taskDispatcher;
            return this;
        }

        public SupervisorStartup build() {
            return new SupervisorStartup(this.currentSupervisor, this.supervisorConfig, this.supervisorRegistry, this.schedulerJobManager, this.scanTriggeringJobLocker, this.scanWaitingInstanceLocker, this.scanRunningInstanceLocker, this.taskDispatcher);
        }
    }
}

