/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.base;

import cn.ponfee.scheduler.common.util.ClassUtils;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractDataSourceConfig {
    public static final String DATA_SOURCE_SUFFIX = "DataSource";
    public static final String SQL_SESSION_FACTORY_SUFFIX = "SqlSessionFactory";
    public static final String SQL_SESSION_TEMPLATE_SUFFIX = "SqlSessionTemplate";
    public static final String TX_MANAGER_SUFFIX = "TransactionManager";
    public static final String TX_TEMPLATE_SUFFIX = "TransactionTemplate";
    public static final String JDBC_TEMPLATE_SUFFIX = "JdbcTemplate";
    private final String mapperFileLocation;

    public AbstractDataSourceConfig() {
        String basePackage = ClassUtils.getPackagePath(this.getClass());
        this.mapperFileLocation = MessageFormat.format("classpath*:{0}xml/*.xml", basePackage);
    }

    public AbstractDataSourceConfig(String mapperFileLocation) {
        this.mapperFileLocation = mapperFileLocation;
    }

    public abstract DataSource dataSource();

    protected final SqlSessionFactory createSqlSessionFactory() throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(this.dataSource());
        factoryBean.setConfigLocation((Resource)new ClassPathResource("mybatis-config.xml"));
        factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mapperFileLocation));
        return factoryBean.getObject();
    }
}

