/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.base;

import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.base.WorkerService;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.handle.JobHandlerUtils;
import cn.ponfee.scheduler.core.handle.SplitTask;
import cn.ponfee.scheduler.registry.DiscoveryRestProxy;
import java.util.List;

public class WorkerServiceClient {
    private static final WorkerService LOCAL_WORKER_SERVICE = new WorkerService(){

        public boolean verify(String jobHandler, String jobParam) {
            return JobHandlerUtils.verify((String)jobHandler, (String)jobParam);
        }

        public List<SplitTask> split(String jobHandler, String jobParam) throws JobException {
            return JobHandlerUtils.split((String)jobHandler, (String)jobParam);
        }
    };
    private final WorkerService remoteWorkerService;
    private final String currentGroup;

    public WorkerServiceClient(WorkerService remoteWorkerService, Worker currentWorker) {
        this.remoteWorkerService = remoteWorkerService;
        this.currentGroup = currentWorker == null ? null : currentWorker.getGroup();
    }

    public boolean verify(String group, String jobHandler, String jobParam) {
        return this.workerService(group).verify(jobHandler, jobParam);
    }

    public List<SplitTask> split(String group, String jobHandler, String jobParam) throws JobException {
        return this.workerService(group).split(jobHandler, jobParam);
    }

    private WorkerService workerService(String group) {
        if (this.remoteWorkerService == null || group.equals(this.currentGroup)) {
            return LOCAL_WORKER_SERVICE;
        }
        if (this.remoteWorkerService instanceof DiscoveryRestProxy.GroupedServer) {
            ((DiscoveryRestProxy.GroupedServer)this.remoteWorkerService).group(group);
        }
        return this.remoteWorkerService;
    }
}

