/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.base.ToJsonString;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="distributed.scheduler.supervisor")
public class SupervisorProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -7896732123210543684L;
    private long scanTriggeringJobPeriodMs = 3000L;
    private long scanWaitingInstancePeriodMs = 5000L;
    private long scanRunningInstancePeriodMs = 30000L;
    private boolean forceLocalWorkerService = false;

    public void check() {
        Assert.isTrue((this.scanTriggeringJobPeriodMs > 0L ? 1 : 0) != 0, (String)"Scan triggering job period ms must be greater than 0.");
        Assert.isTrue((this.scanWaitingInstancePeriodMs > 0L ? 1 : 0) != 0, (String)"Scan waiting instance period ms must be greater than 0.");
        Assert.isTrue((this.scanRunningInstancePeriodMs > 0L ? 1 : 0) != 0, (String)"Scan running instance period ms must be greater than 0.");
    }

    public long getScanTriggeringJobPeriodMs() {
        return this.scanTriggeringJobPeriodMs;
    }

    public long getScanWaitingInstancePeriodMs() {
        return this.scanWaitingInstancePeriodMs;
    }

    public long getScanRunningInstancePeriodMs() {
        return this.scanRunningInstancePeriodMs;
    }

    public boolean isForceLocalWorkerService() {
        return this.forceLocalWorkerService;
    }

    public void setScanTriggeringJobPeriodMs(long scanTriggeringJobPeriodMs) {
        this.scanTriggeringJobPeriodMs = scanTriggeringJobPeriodMs;
    }

    public void setScanWaitingInstancePeriodMs(long scanWaitingInstancePeriodMs) {
        this.scanWaitingInstancePeriodMs = scanWaitingInstancePeriodMs;
    }

    public void setScanRunningInstancePeriodMs(long scanRunningInstancePeriodMs) {
        this.scanRunningInstancePeriodMs = scanRunningInstancePeriodMs;
    }

    public void setForceLocalWorkerService(boolean forceLocalWorkerService) {
        this.forceLocalWorkerService = forceLocalWorkerService;
    }
}

