/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.dao;

import cn.ponfee.scheduler.supervisor.base.AbstractDataSourceConfig;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@MapperScan(basePackages={"cn.ponfee.scheduler.supervisor.dao.mapper"}, sqlSessionTemplateRef="schedulerSqlSessionTemplate")
public class SupervisorDataSourceConfig
extends AbstractDataSourceConfig {
    public static final String BASE_PACKAGE = "cn.ponfee.scheduler.supervisor.dao";
    public static final String DB_NAME = "scheduler";

    @Override
    @Bean(name={"schedulerDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.distributed-scheduler")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"schedulerSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        return super.createSqlSessionFactory();
    }

    @Bean(name={"schedulerSqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    @Bean(name={"schedulerTransactionManager"})
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource());
    }

    @Bean(name={"schedulerTransactionTemplate"})
    public TransactionTemplate transactionTemplate() {
        return new TransactionTemplate((PlatformTransactionManager)this.transactionManager());
    }

    @Bean(name={"schedulerJdbcTemplate"})
    public JdbcTemplate jdbcTemplate() {
        return new JdbcTemplate(this.dataSource());
    }
}

