/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.manager;

import cn.ponfee.scheduler.common.base.IdGenerator;
import cn.ponfee.scheduler.common.base.LazyLoader;
import cn.ponfee.scheduler.common.base.tuple.Tuple3;
import cn.ponfee.scheduler.common.spring.RpcController;
import cn.ponfee.scheduler.common.spring.TransactionUtils;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RetryType;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.enums.RunType;
import cn.ponfee.scheduler.core.enums.TriggerType;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedDepend;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.core.param.TaskWorker;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.base.WorkerServiceClient;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedDependMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedInstanceMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedJobMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedTaskMapper;
import cn.ponfee.scheduler.supervisor.manager.AbstractJobManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Component
public class SchedulerJobManager
extends AbstractJobManager
implements SupervisorService,
RpcController {
    private static final String TX_MANAGER_NAME = "schedulerTransactionManager";
    private static final int AFFECTED_ONE_ROW = 1;
    private static final String DEFAULT_USER = "0";
    private static final List<Integer> CANCELABLE_RUN_STATE_LIST = Collects.convert((List)RunState.CANCELABLE_LIST, RunState::value);
    private static final List<Integer> EXECUTABLE_EXECUTE_STATE_LIST = Collects.convert((List)ExecuteState.EXECUTABLE_LIST, ExecuteState::value);
    private final TransactionTemplate transactionTemplate;
    private final SchedJobMapper jobMapper;
    private final SchedInstanceMapper instanceMapper;
    private final SchedTaskMapper taskMapper;
    private final SchedDependMapper dependMapper;

    public SchedulerJobManager(IdGenerator idGenerator, SupervisorRegistry discoveryWorker, TaskDispatcher taskDispatcher, WorkerServiceClient workerServiceClient, @Qualifier(value="schedulerTransactionTemplate") TransactionTemplate transactionTemplate, SchedJobMapper jobMapper, SchedInstanceMapper instanceMapper, SchedTaskMapper taskMapper, SchedDependMapper dependMapper) {
        super(idGenerator, discoveryWorker, taskDispatcher, workerServiceClient);
        this.transactionTemplate = transactionTemplate;
        this.jobMapper = jobMapper;
        this.instanceMapper = instanceMapper;
        this.taskMapper = taskMapper;
        this.dependMapper = dependMapper;
    }

    public SchedJob getJob(long jobId) {
        return this.jobMapper.getByJobId(jobId);
    }

    public SchedInstance getInstance(long instanceId) {
        return this.instanceMapper.getByInstanceId(instanceId);
    }

    public SchedTask getTask(long taskId) {
        return this.taskMapper.getByTaskId(taskId);
    }

    public List<SchedTask> findMediumTaskByInstanceId(long instanceId) {
        return this.taskMapper.findMediumByInstanceId(instanceId);
    }

    public List<SchedTask> findLargeTaskByInstanceId(long instanceId) {
        return this.taskMapper.findLargeByInstanceId(instanceId);
    }

    public List<SchedJob> findBeTriggering(long maxNextTriggerTime, int size) {
        return this.jobMapper.findBeTriggering(maxNextTriggerTime, size);
    }

    public List<SchedInstance> findExpireWaiting(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.WAITING.value(), expireTime.getTime(), expireTime, size);
    }

    public List<SchedInstance> findExpireRunning(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.RUNNING.value(), expireTime.getTime(), expireTime, size);
    }

    public SchedInstance getByTriggerTime(long jobId, long triggerTime, int runType) {
        return this.instanceMapper.getByTriggerTime(jobId, triggerTime, runType);
    }

    public List<SchedInstance> findUnterminatedRetry(long instanceId) {
        return this.instanceMapper.findUnterminatedRetry(instanceId);
    }

    public boolean checkpoint(long taskId, String executeSnapshot) {
        return this.taskMapper.checkpoint(taskId, executeSnapshot) == 1;
    }

    public boolean renewUpdateTime(SchedInstance instance, Date updateTime) {
        return this.instanceMapper.renewUpdateTime(instance.getInstanceId(), updateTime, instance.getVersion()) == 1;
    }

    public boolean changeJobState(long jobId, JobState to) {
        return this.jobMapper.updateState(jobId, to.value(), 1 ^ to.value()) == 1;
    }

    public boolean stopJob(SchedJob job) {
        return 1 == this.jobMapper.stop(job);
    }

    public boolean updateNextTriggerTime(SchedJob job) {
        return this.jobMapper.updateNextTriggerTime(job) == 1;
    }

    public boolean updateNextScanTime(long jobId, Date nextScanTime, int version) {
        return this.jobMapper.updateNextScanTime(jobId, nextScanTime, version) == 1;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void addJob(SchedJob job) {
        job.verifyBeforeAdd();
        super.verifyJobHandler(job);
        job.checkAndDefaultSetting();
        job.setJobId(Long.valueOf(this.generateId()));
        Date now = new Date();
        this.parseTriggerConfig(job, now);
        job.setCreatedAt(now);
        job.setUpdatedAt(now);
        job.setCreatedBy(DEFAULT_USER);
        job.setUpdatedBy(DEFAULT_USER);
        this.jobMapper.insert(job);
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void updateJob(SchedJob job) {
        job.verifyBeforeUpdate();
        if (StringUtils.isEmpty((CharSequence)job.getJobHandler())) {
            Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)job.getJobParam()), (String)"Job param must be null if not set job handler.");
        } else {
            super.verifyJobHandler(job);
        }
        job.checkAndDefaultSetting();
        SchedJob dbSchedJob = this.jobMapper.getByJobId(job.getJobId());
        Assert.notNull((Object)dbSchedJob, () -> "Sched job id not found " + job.getJobId());
        job.setNextTriggerTime(dbSchedJob.getNextTriggerTime());
        Date now = new Date();
        if (job.getTriggerType() == null) {
            Assert.isNull((Object)job.getTriggerValue(), (String)"Trigger value must be null if not set trigger type.");
        } else {
            Assert.notNull((Object)job.getTriggerValue(), (String)"Trigger value cannot be null if has set trigger type.");
            this.dependMapper.deleteByChildJobId(job.getJobId());
            this.parseTriggerConfig(job, now);
        }
        job.setUpdatedAt(now);
        job.setUpdatedBy(DEFAULT_USER);
        Assert.state((this.jobMapper.updateByJobId(job) == 1 ? 1 : 0) != 0, (String)"Update sched job fail or conflict.");
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void deleteJob(long jobId) {
        Assert.isTrue((this.jobMapper.deleteByJobId(jobId) == 1 ? 1 : 0) != 0, (String)"Delete sched job fail or conflict.");
        this.dependMapper.deleteByParentJobId(jobId);
        this.dependMapper.deleteByChildJobId(jobId);
    }

    public void deleteInstance(long instanceId) {
        this.doTransactionInSynchronized(instanceId, () -> {
            Integer state = this.instanceMapper.lockAndGetState(instanceId);
            Assert.notNull((Object)state, () -> "Sched instance not found: " + instanceId);
            RunState runState = RunState.of((Integer)state);
            Assert.isTrue((boolean)runState.isTerminal(), () -> "Cannot delete unterminated sched instance: " + instanceId + ", run state=" + runState);
            int row = this.instanceMapper.deleteByInstanceId(instanceId);
            Assert.isTrue((row == 1 ? 1 : 0) != 0, () -> "Delete sched instance conflict: " + instanceId);
            this.taskMapper.deleteByInstanceId(instanceId);
        });
    }

    public void forceUpdateInstanceState(long instanceId, int instanceTargetState, int taskTargetState) {
        ExecuteState taskTargetState0 = ExecuteState.of((Integer)taskTargetState);
        Assert.isTrue((taskTargetState0.runState() == RunState.of((Integer)instanceTargetState) ? 1 : 0) != 0, () -> "Inconsistent state: " + instanceTargetState + ", " + taskTargetState);
        this.doTransactionInSynchronized(instanceId, () -> {
            Long id = this.instanceMapper.lockAndGetId(instanceId);
            Assert.notNull((Object)id, () -> "Sched instance not found: " + instanceId);
            int row = this.instanceMapper.forceUpdateState(instanceId, instanceTargetState);
            Assert.isTrue((row == 1 ? 1 : 0) != 0, () -> "Sched instance state update failed " + instanceId);
            row = this.taskMapper.forceUpdateState(instanceId, taskTargetState);
            Assert.isTrue((row >= 1 ? 1 : 0) != 0, () -> "Sched task state update failed, instance_id=" + instanceId);
            if (taskTargetState0 == ExecuteState.WAITING) {
                Tuple3<SchedJob, SchedInstance, List<SchedTask>> params = this.buildDispatchParams(instanceId, row);
                TransactionUtils.doAfterTransactionCommit(() -> super.dispatch((SchedJob)params.a, (SchedInstance)params.b, (List)params.c));
            }
        });
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void triggerJob(long jobId) throws JobException {
        SchedJob job = this.jobMapper.getByJobId(jobId);
        Assert.notNull((Object)job, () -> "Sched job not found: " + jobId);
        Date now = new Date();
        SchedInstance instance = SchedInstance.create((long)this.generateId(), (long)job.getJobId(), (RunType)RunType.MANUAL, (long)now.getTime(), (int)0, (Date)now);
        List<SchedTask> tasks = this.splitTasks(job, instance.getInstanceId(), now);
        int row = this.instanceMapper.insert(instance);
        Assert.state((row == 1 ? 1 : 0) != 0, () -> "Insert sched instance fail: " + instance);
        this.batchInsertTask(tasks);
        TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(job, instance, tasks));
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean updateAndSave(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        int row = this.jobMapper.updateNextTriggerTime(job);
        if (row == 0) {
            return false;
        }
        row = this.instanceMapper.insert(instance);
        Assert.state((row == 1 ? 1 : 0) != 0, () -> "Insert sched instance fail: " + instance);
        this.batchInsertTask(tasks);
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean updateTaskWorker(List<TaskWorker> list) {
        List partition = list.size() <= 200 ? Collections.singletonList(list) : Lists.partition(list, (int)200);
        return partition.stream().mapToInt(this.taskMapper::batchUpdateWorker).sum() >= 1;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean startTask(ExecuteParam param) {
        Integer state = this.instanceMapper.getStateByInstanceId(param.getInstanceId());
        Assert.state((state != null ? 1 : 0) != 0, () -> "Sched instance not found: " + param);
        RunState runState = RunState.of((Integer)state);
        Assert.state((boolean)RunState.PAUSABLE_LIST.contains(runState), () -> "Start instance failed: " + param + ", " + runState);
        Date now = new Date();
        int instanceRow = this.instanceMapper.start(param.getInstanceId(), now);
        int taskRow = this.taskMapper.start(param.getTaskId(), param.getWorker().toString(), now);
        if (instanceRow == 0 && taskRow == 0) {
            return false;
        }
        Assert.state((taskRow == 1 ? 1 : 0) != 0, () -> "Start task failed: " + param);
        return true;
    }

    public boolean terminateExecutingTask(ExecuteParam param, ExecuteState toState, String errorMsg) {
        return this.doTransactionInSynchronized(param.getInstanceId(), () -> {
            RunState runState;
            Integer state = this.instanceMapper.lockAndGetState(param.getInstanceId());
            Assert.notNull((Object)state, () -> "Terminate failed, instance_id not found: " + param.getInstanceId());
            if (RunState.of((Integer)state).isTerminal()) {
                return false;
            }
            if (this.taskMapper.terminate(param.getTaskId(), toState.value(), ExecuteState.EXECUTING.value(), new Date(), errorMsg) == 0) {
                this.log.warn("Conflict terminate executing task {}, {}", (Object)param.getTaskId(), (Object)toState);
                return false;
            }
            List<SchedTask> tasks = this.taskMapper.findMediumByInstanceId(param.getInstanceId());
            List taskStateList = tasks.stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).collect(Collectors.toList());
            if (!taskStateList.stream().allMatch(ExecuteState::isTerminal)) {
                return true;
            }
            Date runEndTime = tasks.stream().map(SchedTask::getExecuteEndTime).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElseGet(Date::new);
            RunState runState2 = runState = taskStateList.stream().allMatch(arg_0 -> ((ExecuteState)ExecuteState.FINISHED).equals(arg_0)) ? RunState.FINISHED : RunState.CANCELED;
            if (this.instanceMapper.terminate(param.getInstanceId(), runState.value(), CANCELABLE_RUN_STATE_LIST, runEndTime) == 1) {
                this.terminatePostProcess(param.getInstanceId(), runState);
            }
            return true;
        });
    }

    public boolean terminateDeadInstance(long instanceId) {
        return this.doTransactionInSynchronized(instanceId, () -> {
            RunState runState;
            Date runEndTime;
            Integer state = this.instanceMapper.lockAndGetState(instanceId);
            Assert.notNull((Object)state, () -> "Terminate failed, instance_id not found: " + instanceId);
            if (RunState.of((Integer)state).isTerminal()) {
                return false;
            }
            List<SchedTask> tasks = this.taskMapper.findMediumByInstanceId(instanceId);
            if (CollectionUtils.isEmpty(tasks)) {
                this.log.error("Not found sched instance task data {}", (Object)instanceId);
                return false;
            }
            List taskStateList = tasks.stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).collect(Collectors.toList());
            if (taskStateList.stream().allMatch(ExecuteState::isTerminal)) {
                runEndTime = tasks.stream().map(SchedTask::getExecuteEndTime).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElseGet(Date::new);
                runState = taskStateList.stream().allMatch(arg_0 -> ((ExecuteState)ExecuteState.FINISHED).equals(arg_0)) ? RunState.FINISHED : RunState.CANCELED;
            } else if (taskStateList.stream().allMatch(e -> e == ExecuteState.PAUSED || e.isTerminal())) {
                runEndTime = null;
                runState = RunState.PAUSED;
            } else {
                runEndTime = new Date();
                runState = RunState.CANCELED;
            }
            if (this.instanceMapper.terminate(instanceId, runState.value(), CANCELABLE_RUN_STATE_LIST, runEndTime) != 1) {
                return false;
            }
            tasks.stream().filter(e -> !ExecuteState.of((Integer)e.getExecuteState()).isTerminal()).forEach(e -> this.taskMapper.terminate(e.getTaskId(), ExecuteState.EXECUTE_TIMEOUT.value(), e.getExecuteState(), new Date(), null));
            this.terminatePostProcess(instanceId, runState);
            return true;
        });
    }

    public boolean pauseInstance(long instanceId) {
        return this.doTransactionInSynchronized(instanceId, () -> {
            Integer state = this.instanceMapper.lockAndGetState(instanceId);
            Assert.notNull((Object)state, () -> "Pause failed, instance_id not found: " + instanceId);
            RunState runState = RunState.of((Integer)state);
            if (!RunState.PAUSABLE_LIST.contains(runState)) {
                return false;
            }
            List<Integer> fromStateList = Collections.singletonList(ExecuteState.WAITING.value());
            this.taskMapper.updateStateByInstanceId(instanceId, ExecuteState.PAUSED.value(), fromStateList, null);
            List<ExecuteParam> executingTasks = this.loadExecutingTasks(instanceId, Operations.PAUSE);
            if (executingTasks.isEmpty()) {
                List stateList = this.taskMapper.findMediumByInstanceId(instanceId).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).collect(Collectors.toList());
                RunState toRunState = stateList.stream().anyMatch(arg_0 -> ((ExecuteState)ExecuteState.PAUSED).equals(arg_0)) ? RunState.PAUSED : (stateList.stream().anyMatch(ExecuteState::isFailure) ? RunState.CANCELED : RunState.FINISHED);
                int row = toRunState.isTerminal() ? this.instanceMapper.terminate(instanceId, toRunState.value(), Collections.singletonList(runState.value()), new Date()) : this.instanceMapper.updateState(instanceId, toRunState.value(), runState.value(), null);
                if (row != 1) {
                    this.log.warn("Pause instance from {} to {} conflict", (Object)runState, (Object)toRunState);
                }
            } else {
                TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(executingTasks));
            }
            return true;
        });
    }

    public boolean pauseExecutingTask(ExecuteParam param, String errorMsg) {
        return this.doTransactionInSynchronized(param.getInstanceId(), () -> {
            Integer state = this.instanceMapper.lockAndGetState(param.getInstanceId());
            if (!RunState.RUNNING.equals(state)) {
                this.log.warn("Pause executing task failed: {} | {}", (Object)param, (Object)state);
                return false;
            }
            int row = this.taskMapper.updateState(param.getTaskId(), ExecuteState.PAUSED.value(), ExecuteState.EXECUTING.value(), errorMsg, null);
            if (row != 1) {
                this.log.warn("Paused task unsuccessful.");
                return false;
            }
            boolean allPaused = this.taskMapper.findMediumByInstanceId(param.getInstanceId()).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).noneMatch(ExecuteState.PAUSABLE_LIST::contains);
            if (allPaused && (row = this.instanceMapper.updateState(param.getInstanceId(), RunState.PAUSED.value(), RunState.RUNNING.value(), null)) != 1) {
                this.log.error("Update sched instance to paused state conflict: {} | {}", (Object)param.getInstanceId(), (Object)param.getTaskId());
            }
            return true;
        });
    }

    public boolean cancelInstance(long instanceId, Operations operation) {
        Assert.isTrue((boolean)operation.targetState().isFailure(), () -> "Expect cancel ops, but actual: " + operation);
        return this.doTransactionInSynchronized(instanceId, () -> {
            Integer state = this.instanceMapper.lockAndGetState(instanceId);
            Assert.notNull((Object)state, () -> "Cancel failed, instance_id not found: " + instanceId);
            RunState runState = RunState.of((Integer)state);
            if (runState.isTerminal()) {
                return false;
            }
            this.taskMapper.updateStateByInstanceId(instanceId, operation.targetState().value(), EXECUTABLE_EXECUTE_STATE_LIST, new Date());
            List<ExecuteParam> executingTasks = this.loadExecutingTasks(instanceId, operation);
            if (executingTasks.isEmpty()) {
                boolean failure = this.taskMapper.findMediumByInstanceId(instanceId).stream().anyMatch(e -> ExecuteState.of((Integer)e.getExecuteState()).isFailure());
                RunState toRunState = failure ? RunState.CANCELED : RunState.FINISHED;
                int row = this.instanceMapper.terminate(instanceId, toRunState.value(), Collections.singletonList(runState.value()), new Date());
                if (row != 1) {
                    this.log.warn("Pause instance from {} to {} conflict", (Object)runState, (Object)toRunState);
                }
            } else {
                TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(executingTasks));
            }
            return true;
        });
    }

    public boolean cancelExecutingTask(ExecuteParam param, ExecuteState toState, String errorMsg) {
        Assert.isTrue((boolean)toState.isFailure(), () -> "Target state expect failure state, but actual: " + toState);
        return this.doTransactionInSynchronized(param.getInstanceId(), () -> {
            Integer state = this.instanceMapper.lockAndGetState(param.getInstanceId());
            if (!RunState.RUNNING.equals(state)) {
                return false;
            }
            int row = this.taskMapper.terminate(param.getTaskId(), toState.value(), ExecuteState.EXECUTING.value(), new Date(), errorMsg);
            if (row != 1) {
                this.log.warn("Canceled task unsuccessful.");
                return false;
            }
            boolean allTerminated = this.taskMapper.findMediumByInstanceId(param.getInstanceId()).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).allMatch(ExecuteState::isTerminal);
            if (allTerminated && (row = this.instanceMapper.terminate(param.getInstanceId(), RunState.CANCELED.value(), Collections.singletonList(RunState.RUNNING.value()), new Date())) != 1) {
                this.log.error("Update sched instance to canceled state conflict: {} | {}", (Object)param.getInstanceId(), (Object)param.getTaskId());
            }
            return true;
        });
    }

    public boolean resumeInstance(long instanceId) {
        return this.doTransactionInSynchronized(instanceId, () -> {
            Integer state = this.instanceMapper.lockAndGetState(instanceId);
            Assert.notNull((Object)state, () -> "Cancel failed, instance_id not found: " + instanceId);
            if (!RunState.PAUSED.equals(state)) {
                return false;
            }
            int row = this.instanceMapper.updateState(instanceId, RunState.WAITING.value(), RunState.PAUSED.value(), null);
            Assert.state((row == 1 ? 1 : 0) != 0, (String)"Resume sched instance failed.");
            row = this.taskMapper.updateStateByInstanceId(instanceId, ExecuteState.WAITING.value(), Collections.singletonList(ExecuteState.PAUSED.value()), null);
            Assert.state((row >= 1 ? 1 : 0) != 0, (String)"Resume sched task failed.");
            Tuple3<SchedJob, SchedInstance, List<SchedTask>> params = this.buildDispatchParams(instanceId, row);
            TransactionUtils.doAfterTransactionCommit(() -> super.dispatch((SchedJob)params.a, (SchedInstance)params.b, (List)params.c));
            return true;
        });
    }

    public boolean updateInstanceState(ExecuteState toState, List<SchedTask> tasks, SchedInstance instance) {
        return this.doTransactionInSynchronized((long)instance.getInstanceId(), () -> {
            if (this.instanceMapper.lockAndGetId(instance.getInstanceId()) == null) {
                return false;
            }
            int row = this.instanceMapper.updateState(instance.getInstanceId(), toState.runState().value(), instance.getRunState(), instance.getVersion());
            if (row != 1) {
                this.log.warn("Conflict update instance run state: {} | {}", (Object)instance, (Object)toState.runState());
                return false;
            }
            row = 0;
            for (SchedTask task : tasks) {
                row += this.taskMapper.updateState(task.getTaskId(), toState.value(), task.getExecuteState(), null, task.getVersion());
            }
            Assert.state((row >= 1 ? 1 : 0) != 0, () -> "Conflict update state: " + toState + ", " + tasks + ", " + instance);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTransactionInSynchronized(long lockKey, Supplier<Boolean> action) {
        String string = Long.toString(lockKey).intern();
        synchronized (string) {
            return Boolean.TRUE.equals(this.transactionTemplate.execute(status -> (Boolean)action.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransactionInSynchronized(long lockKey, Runnable action) {
        String string = Long.toString(lockKey).intern();
        synchronized (string) {
            this.transactionTemplate.executeWithoutResult(status -> action.run());
        }
    }

    private void terminatePostProcess(long instanceId, RunState runState) {
        if (runState == RunState.CANCELED) {
            this.retryJobIfNecessary(instanceId);
        } else if (runState == RunState.FINISHED) {
            this.dependJobIfNecessary(instanceId);
        } else {
            this.log.error("Unknown retry run state " + runState);
        }
    }

    private void retryJobIfNecessary(long instanceId) {
        List<Object> tasks;
        SchedInstance prevInstance = this.instanceMapper.getByInstanceId(instanceId);
        SchedJob schedJob = this.jobMapper.getByJobId(prevInstance.getJobId());
        if (schedJob == null) {
            this.log.error("Sched job not found {}", (Object)prevInstance.getJobId());
            return;
        }
        List<SchedTask> prevTasks = this.taskMapper.findLargeByInstanceId(instanceId);
        RetryType retryType = RetryType.of((Integer)schedJob.getRetryType());
        if (retryType == RetryType.NONE || schedJob.getRetryCount() < 1) {
            return;
        }
        int retriedCount = Optional.ofNullable(prevInstance.getRetriedCount()).orElse(0);
        if (retriedCount >= schedJob.getRetryCount()) {
            return;
        }
        Date now = new Date();
        long triggerTime = SchedulerJobManager.computeRetryTriggerTime(schedJob, ++retriedCount, now);
        SchedInstance retryInstance = SchedInstance.create((long)this.generateId(), (long)schedJob.getJobId(), (RunType)RunType.RETRY, (long)triggerTime, (int)retriedCount, (Date)now);
        retryInstance.setParentInstanceId(prevInstance.obtainRootInstanceId());
        switch (retryType) {
            case ALL: {
                try {
                    tasks = this.splitTasks(schedJob, retryInstance.getInstanceId(), now);
                    break;
                }
                catch (Exception e2) {
                    this.log.error("Split job error: " + schedJob + ", " + prevInstance, (Throwable)e2);
                    return;
                }
            }
            case FAILED: {
                tasks = prevTasks.stream().filter(e -> ExecuteState.of((Integer)e.getExecuteState()).isFailure()).map(e -> SchedTask.create((String)e.getTaskParam(), (long)this.generateId(), (long)retryInstance.getInstanceId(), (Date)now)).collect(Collectors.toList());
                break;
            }
            default: {
                this.log.error("Job unsupported retry type {}", (Object)schedJob);
                return;
            }
        }
        Assert.notEmpty(tasks, (String)"Insert list of task cannot be empty.");
        this.instanceMapper.insert(retryInstance);
        this.batchInsertTask(tasks);
        TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(schedJob, retryInstance, tasks));
    }

    private void dependJobIfNecessary(long instanceId) {
        SchedInstance parentInstance = this.instanceMapper.getByInstanceId(instanceId);
        List<SchedDepend> schedDepends = this.dependMapper.findByParentJobId(parentInstance.getJobId());
        if (CollectionUtils.isEmpty(schedDepends)) {
            return;
        }
        for (SchedDepend depend : schedDepends) {
            SchedJob childJob = this.jobMapper.getByJobId(depend.getChildJobId());
            if (childJob == null) {
                this.log.error("Child sched job not found {}, {}", (Object)depend.getParentJobId(), (Object)depend.getChildJobId());
                return;
            }
            if (JobState.DISABLE.equals(childJob.getJobState())) {
                return;
            }
            try {
                Date now = new Date();
                SchedInstance instance = SchedInstance.create((long)this.generateId(), (long)childJob.getJobId(), (RunType)RunType.DEPEND, (long)parentInstance.getTriggerTime(), (int)0, (Date)now);
                instance.setParentInstanceId(parentInstance.obtainRootInstanceId());
                List<SchedTask> tasks = this.splitTasks(childJob, instance.getInstanceId(), now);
                this.instanceMapper.insert(instance);
                this.batchInsertTask(tasks);
                TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(childJob, instance, tasks));
            }
            catch (Exception e) {
                this.log.error("Depend job split failed: " + childJob, (Throwable)e);
            }
        }
    }

    private void batchInsertTask(List<SchedTask> tasks) {
        Assert.notEmpty(tasks, (String)"Insert list of task cannot be empty.");
        if (tasks.size() <= 200) {
            int row = this.taskMapper.batchInsert(tasks);
            Assert.state((row == tasks.size() ? 1 : 0) != 0, () -> "Insert sched task fail: " + tasks);
        } else {
            for (List list : Lists.partition(tasks, (int)200)) {
                int row = this.taskMapper.batchInsert(list);
                Assert.state((row == list.size() ? 1 : 0) != 0, () -> "Insert sched task fail: " + tasks);
            }
        }
    }

    private List<ExecuteParam> loadExecutingTasks(long instanceId, Operations ops) {
        SchedInstance schedInstanceProxy = (SchedInstance)LazyLoader.of(SchedInstance.class, this.instanceMapper::getByInstanceId, (Object)instanceId);
        ArrayList<ExecuteParam> executingTasks = new ArrayList<ExecuteParam>();
        this.taskMapper.findMediumByInstanceId(instanceId).stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).forEach(task -> {
            Worker worker = Worker.deserialize((String)task.getWorker());
            if (super.isAliveWorker(worker)) {
                ExecuteParam param = new ExecuteParam(ops, task.getTaskId().longValue(), instanceId, schedInstanceProxy.getJobId().longValue(), 0L);
                param.setWorker(worker);
                executingTasks.add(param);
            } else {
                this.log.info("Cancel the dead task {}", task);
                this.taskMapper.updateState(task.getTaskId(), ops.targetState().value(), ExecuteState.EXECUTING.value(), null, null);
            }
        });
        return executingTasks;
    }

    private Tuple3<SchedJob, SchedInstance, List<SchedTask>> buildDispatchParams(long instanceId, int expectTaskSize) {
        SchedInstance instance = this.instanceMapper.getByInstanceId(instanceId);
        SchedJob job = this.jobMapper.getByJobId(instance.getJobId());
        List waitingTasks = this.taskMapper.findLargeByInstanceId(instanceId).stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).collect(Collectors.toList());
        Assert.isTrue((waitingTasks.size() == expectTaskSize ? 1 : 0) != 0, () -> "Dispatching tasks size inconsistent, expect=" + expectTaskSize + ", actual=" + waitingTasks.size());
        return Tuple3.of((Object)job, (Object)instance, waitingTasks);
    }

    private void parseTriggerConfig(SchedJob job, Date date) {
        TriggerType triggerType = TriggerType.of((Integer)job.getTriggerType());
        Assert.isTrue((boolean)triggerType.isValid(job.getTriggerValue()), () -> "Invalid trigger value: " + job.getTriggerType() + ", " + job.getTriggerValue());
        if (triggerType == TriggerType.DEPEND) {
            List<Long> parentJobIds = Arrays.stream(job.getTriggerValue().split(",")).filter(StringUtils::isNotBlank).map(e -> Long.parseLong(e.trim())).distinct().collect(Collectors.toList());
            Assert.notEmpty(parentJobIds, () -> "Invalid dependency parent job id config: " + job.getTriggerValue());
            Map parentJobMap = this.jobMapper.findByJobIds(parentJobIds).stream().collect(Collectors.toMap(SchedJob::getJobId, Function.identity()));
            for (Long parentJobId : parentJobIds) {
                SchedJob parentJob = (SchedJob)parentJobMap.get(parentJobId);
                Assert.notNull((Object)parentJob, () -> "Parent job id not found: " + parentJobId);
                Assert.isTrue((boolean)job.getJobGroup().equals(parentJob.getJobGroup()), () -> "Parent job '" + parentJob.getJobId() + "' group '" + parentJob.getJobGroup() + "' different '" + job.getJobGroup() + "'");
            }
            this.dependMapper.insertBatch(parentJobIds.stream().map(e -> new SchedDepend(e, job.getJobId())).collect(Collectors.toList()));
            job.setTriggerValue(Joiner.on((String)",").join(parentJobIds));
            job.setNextTriggerTime(null);
        } else {
            Date nextTriggerTime = triggerType.computeNextFireTime(job.getTriggerValue(), date);
            Assert.notNull((Object)nextTriggerTime, () -> "Has not next trigger time " + job.getTriggerValue());
            job.setNextTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
        }
    }

    private static long computeRetryTriggerTime(SchedJob job, int failCount, Date current) {
        Assert.isTrue((!RetryType.NONE.equals(job.getRetryType()) ? 1 : 0) != 0, () -> "Sched job '" + job.getJobId() + "' retry type is NONE.");
        Assert.isTrue((job.getRetryCount() > 0 ? 1 : 0) != 0, () -> "Sched job '" + job.getJobId() + "' retry count must greater than 0, but actual " + job.getRetryCount());
        Assert.isTrue((failCount <= job.getRetryCount() ? 1 : 0) != 0, () -> "Sched job '" + job.getJobId() + "' retried " + failCount + " exceed " + job.getRetryCount() + " limit.");
        return current.getTime() + (long)job.getRetryInterval().intValue() * (long)IntMath.pow((int)failCount, (int)2);
    }
}

