/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.thread;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.AbstractHeartbeatThread;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class RunningInstanceScanner
extends AbstractHeartbeatThread {
    private final DoInLocked doInLocked;
    private final SchedulerJobManager schedulerJobManager;
    private final long beforeMilliseconds;

    public RunningInstanceScanner(long heartbeatPeriodMilliseconds, DoInLocked doInLocked, SchedulerJobManager schedulerJobManager) {
        super(heartbeatPeriodMilliseconds);
        this.doInLocked = doInLocked;
        this.schedulerJobManager = schedulerJobManager;
        this.beforeMilliseconds = this.heartbeatPeriodMs << 2;
    }

    protected boolean heartbeat() {
        if (this.schedulerJobManager.hasNotDiscoveredWorkers()) {
            this.log.warn("Not found available worker.");
            return true;
        }
        Boolean result = (Boolean)this.doInLocked.apply(this::process);
        return result == null || result != false;
    }

    private boolean process() {
        Date now = new Date();
        Date expireTime = new Date(now.getTime() - this.beforeMilliseconds);
        List<SchedInstance> instances = this.schedulerJobManager.findExpireRunning(expireTime, 200);
        if (CollectionUtils.isEmpty(instances)) {
            return true;
        }
        for (SchedInstance instance : instances) {
            this.processEach(instance, now);
        }
        return instances.size() < 200;
    }

    private void processEach(SchedInstance instance, Date now) {
        List<SchedTask> tasks = this.schedulerJobManager.findMediumTaskByInstanceId(instance.getInstanceId());
        List<SchedTask> waitingTasks = tasks.stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(waitingTasks)) {
            List<SchedTask> dispatchingTasks;
            if (this.schedulerJobManager.renewUpdateTime(instance, now) && CollectionUtils.isNotEmpty(dispatchingTasks = this.schedulerJobManager.filterDispatchingTask(waitingTasks))) {
                this.log.info("Redispatch sched instance: {} | {}", (Object)instance, (Object)Jsons.toJson(dispatchingTasks));
                SchedJob schedJob = this.schedulerJobManager.getJob(instance.getJobId());
                this.schedulerJobManager.dispatch(schedJob, instance, dispatchingTasks);
            }
            return;
        }
        if (this.schedulerJobManager.hasAliveExecuting(tasks)) {
            this.schedulerJobManager.renewUpdateTime(instance, now);
            return;
        }
        this.log.info("Scan instance, all worker dead, terminate the sched instance: {}", (Object)instance.getInstanceId());
        this.schedulerJobManager.terminateDeadInstance(instance.getInstanceId());
    }
}

