/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.lock.DoInDatabaseLocked;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.spring.SpringContextHolder;
import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.HttpProperties;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.base.WorkerService;
import cn.ponfee.scheduler.core.util.JobUtils;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.DiscoveryRestProxy;
import cn.ponfee.scheduler.registry.DiscoveryRestTemplate;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.SupervisorStartup;
import cn.ponfee.scheduler.supervisor.base.WorkerServiceClient;
import cn.ponfee.scheduler.supervisor.configuration.SupervisorProperties;
import cn.ponfee.scheduler.supervisor.configuration.SupervisorStartupRunner;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@EnableConfigurationProperties(value={SupervisorProperties.class})
@Import(value={EnableHttpProperties.class, EnableSupervisorConfiguration.class, EnableComponentScan.class, SupervisorStartupRunner.class})
public @interface EnableSupervisor {

    @ConditionalOnProperty(value={"server.port"})
    public static class EnableSupervisorConfiguration {
        @AutoConfigureOrder(value=-2147483648)
        @Order(value=-2147483648)
        @ConditionalOnMissingBean
        @Bean(value={"distributed.scheduler.bean.current-supervisor"})
        public Supervisor currentSupervisor(@Value(value="${server.port}") int port, @Value(value="${distributed.scheduler.bound.server.host:}") String boundHost) {
            String host = JobUtils.getLocalHost((String)boundHost);
            Supervisor currentSupervisor = new Supervisor(host, port);
            try {
                ClassUtils.invoke(Class.forName(Supervisor.class.getName() + "$Current"), (String)"set", (Object[])new Object[]{currentSupervisor});
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Setting as current supervisor occur error.", e);
            }
            return currentSupervisor;
        }

        @DependsOn(value={"distributed.scheduler.bean.current-supervisor"})
        @ConditionalOnMissingBean
        @Bean
        public WorkerServiceClient workerServiceClient(HttpProperties properties, SupervisorRegistry supervisorRegistry, @Nullable Worker currentWorker, @Nullable @Qualifier(value="distributed.scheduler.bean.object-mapper") ObjectMapper objectMapper) {
            DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().connectTimeout(properties.getConnectTimeout()).readTimeout(properties.getReadTimeout()).maxRetryTimes(properties.getMaxRetryTimes()).objectMapper(objectMapper != null ? objectMapper : Jsons.createObjectMapper((JsonInclude.Include)JsonInclude.Include.NON_NULL)).discoveryServer((Discovery)supervisorRegistry).build();
            WorkerService remoteWorkerService = (WorkerService)DiscoveryRestProxy.create((boolean)true, WorkerService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
            return new WorkerServiceClient(remoteWorkerService, currentWorker);
        }

        @Bean(value={"scan-triggering-job-locker"})
        public DoInLocked scanTriggeringJobLocker(@Qualifier(value="schedulerJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_triggering_job' FOR UPDATE");
        }

        @Bean(value={"scan-waiting-instance-locker"})
        public DoInLocked scanWaitingInstanceLocker(@Qualifier(value="schedulerJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_waiting_instance' FOR UPDATE");
        }

        @Bean(value={"scan-running-instance-locker"})
        public DoInLocked scanRunningInstanceLocker(@Qualifier(value="schedulerJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DoInDatabaseLocked(jdbcTemplate, "SELECT name FROM sched_lock WHERE name='scan_running_instance' FOR UPDATE");
        }

        @ConditionalOnMissingBean
        @Bean
        public SpringContextHolder springContextHolder() {
            return new SpringContextHolder();
        }
    }

    @ComponentScan(basePackageClasses={SupervisorStartup.class})
    public static class EnableComponentScan {
    }

    @ConditionalOnMissingBean(value={HttpProperties.class})
    @EnableConfigurationProperties(value={HttpProperties.class})
    public static class EnableHttpProperties {
    }
}

