/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.instance;

import cn.ponfee.scheduler.core.enums.RunType;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.instance.TriggerInstance;
import cn.ponfee.scheduler.supervisor.instance.TriggerInstanceCreator;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import cn.ponfee.scheduler.supervisor.param.SplitJobParam;
import java.util.Date;
import java.util.List;

public class NormalInstanceCreator
extends TriggerInstanceCreator<NormalInstance> {
    public NormalInstanceCreator(SchedulerJobManager manager) {
        super(manager);
    }

    @Override
    public NormalInstance create(SchedJob job, RunType runType, long triggerTime) throws JobException {
        Date now = new Date();
        long instanceId = this.manager.generateId();
        SchedInstance instance = SchedInstance.create((long)instanceId, (long)job.getJobId(), (RunType)runType, (long)triggerTime, (int)0, (Date)now);
        List<SchedTask> tasks = this.manager.splitTasks(SplitJobParam.from(job), instanceId, now);
        return new NormalInstance(instance, tasks);
    }

    @Override
    public void dispatch(SchedJob job, NormalInstance instance) {
        this.manager.dispatch(job, instance.getInstance(), instance.getTasks());
    }

    public static class NormalInstance
    extends TriggerInstance {
        private final List<SchedTask> tasks;

        public NormalInstance(SchedInstance instance, List<SchedTask> tasks) {
            super(instance);
            this.tasks = tasks;
        }

        public List<SchedTask> getTasks() {
            return this.tasks;
        }
    }
}

