/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.instance;

import cn.ponfee.scheduler.core.enums.JobType;
import cn.ponfee.scheduler.core.enums.RunType;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.supervisor.instance.NormalInstanceCreator;
import cn.ponfee.scheduler.supervisor.instance.TriggerInstance;
import cn.ponfee.scheduler.supervisor.instance.WorkflowInstanceCreator;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;

public abstract class TriggerInstanceCreator<T extends TriggerInstance> {
    protected final SchedulerJobManager manager;

    public TriggerInstanceCreator(SchedulerJobManager manager) {
        this.manager = manager;
    }

    public final void createAndDispatch(SchedJob job, RunType runType, long triggerTime) throws JobException {
        T ti = this.create(job, runType, triggerTime);
        if (this.manager.createInstance(job, (TriggerInstance)ti)) {
            this.dispatch(job, ti);
        }
    }

    public abstract T create(SchedJob var1, RunType var2, long var3) throws JobException;

    public abstract void dispatch(SchedJob var1, T var2);

    public static TriggerInstanceCreator<?> of(Integer jobType, SchedulerJobManager manager) {
        switch (JobType.of((Integer)jobType)) {
            case NORMAL: {
                return new NormalInstanceCreator(manager);
            }
            case WORKFLOW: {
                return new WorkflowInstanceCreator(manager);
            }
        }
        throw new UnsupportedOperationException("Unknown job type: " + jobType);
    }
}

