/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.manager;

import cn.ponfee.scheduler.common.base.IdGenerator;
import cn.ponfee.scheduler.common.model.CodeMsg;
import cn.ponfee.scheduler.core.base.JobCodeMsg;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RouteStrategy;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.handle.SplitTask;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.param.ExecuteTaskParam;
import cn.ponfee.scheduler.core.param.ExecuteTaskParamBuilder;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.base.WorkerServiceClient;
import cn.ponfee.scheduler.supervisor.param.SplitJobParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractJobManager {
    private static final int MAX_SPLIT_TASK_SIZE = 10000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IdGenerator idGenerator;
    private final SupervisorRegistry discoveryWorker;
    private final TaskDispatcher taskDispatcher;
    private final WorkerServiceClient workerServiceClient;

    public long generateId() {
        return this.idGenerator.generateId();
    }

    public void verifyJob(SchedJob job) {
        Assert.hasText((String)job.getJobHandler(), (String)"Job handler cannot be empty.");
        boolean result = this.workerServiceClient.verify(job.getJobGroup(), job.getJobHandler(), job.getJobParam());
        Assert.isTrue((boolean)result, () -> "Invalid job: " + job.getJobHandler());
    }

    public List<SchedTask> splitTasks(SplitJobParam param, long instanceId, Date date) throws JobException {
        if (RouteStrategy.BROADCAST.equals(Integer.valueOf(param.getRouteStrategy()))) {
            List discoveredServers = this.discoveryWorker.getDiscoveredServers(param.getJobGroup());
            if (discoveredServers.isEmpty()) {
                throw new JobException((CodeMsg)JobCodeMsg.NOT_DISCOVERED_WORKER);
            }
            int count = discoveredServers.size();
            return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)param.getJobParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, (String)((Worker)discoveredServers.get(i)).serialize())).collect(Collectors.toList());
        }
        List<SplitTask> split = this.workerServiceClient.split(param.getJobGroup(), param.getJobHandler(), param.getJobParam());
        Assert.notEmpty(split, () -> "Not split any task: " + (Object)((Object)param));
        Assert.isTrue((split.size() <= 10000 ? 1 : 0) != 0, () -> "Split task size must less than 10000, job=" + (Object)((Object)param));
        int count = split.size();
        return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)((SplitTask)split.get(i)).getTaskParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, null)).collect(Collectors.toList());
    }

    public boolean hasAliveExecuting(List<SchedTask> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return false;
        }
        return tasks.stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).map(SchedTask::getWorker).anyMatch(this::isAliveWorker);
    }

    public boolean isAliveWorker(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && this.isAliveWorker(Worker.deserialize((String)text));
    }

    public boolean isDeadWorker(String text) {
        return !this.isAliveWorker(text);
    }

    public boolean isAliveWorker(Worker worker) {
        return worker != null && this.discoveryWorker.isDiscoveredServer((Server)worker);
    }

    public boolean isDeadWorker(Worker worker) {
        return !this.isAliveWorker(worker);
    }

    public boolean hasNotDiscoveredWorkers(String group) {
        return CollectionUtils.isEmpty((Collection)this.discoveryWorker.getDiscoveredServers(group));
    }

    public boolean hasNotDiscoveredWorkers() {
        return !this.discoveryWorker.hasDiscoveredServers();
    }

    public boolean dispatch(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        boolean isBroadcast = RouteStrategy.BROADCAST.equals(job.getRouteStrategy());
        ExecuteTaskParamBuilder builder = ExecuteTaskParam.builder((SchedInstance)instance, (SchedJob)job);
        ArrayList<ExecuteTaskParam> list = new ArrayList<ExecuteTaskParam>(tasks.size());
        for (SchedTask task : tasks) {
            if (isBroadcast) {
                Assert.hasText((String)task.getWorker(), () -> "Broadcast route strategy worker must pre assign: " + task.getTaskId());
                Worker worker = Worker.deserialize((String)task.getWorker());
                if (this.isDeadWorker(worker)) {
                    this.cancelWaitingTask(task.getTaskId());
                    continue;
                }
                list.add(builder.build(Operations.TRIGGER, task.getTaskId().longValue(), instance.getTriggerTime().longValue(), worker));
                continue;
            }
            Assert.isTrue((boolean)StringUtils.isBlank((CharSequence)task.getWorker()), () -> job.getRouteStrategy() + " route strategy worker must be null: " + task.getTaskId());
            list.add(builder.build(Operations.TRIGGER, task.getTaskId().longValue(), instance.getTriggerTime().longValue(), null));
        }
        return this.taskDispatcher.dispatch(list, job.getJobGroup());
    }

    public boolean dispatch(List<ExecuteTaskParam> params) {
        ArrayList<ExecuteTaskParam> list = new ArrayList<ExecuteTaskParam>(params.size());
        for (ExecuteTaskParam param : params) {
            if (RouteStrategy.BROADCAST == param.getRouteStrategy() && this.isDeadWorker(param.getWorker())) {
                this.cancelWaitingTask(param.getTaskId());
                continue;
            }
            list.add(param);
        }
        return this.taskDispatcher.dispatch(list);
    }

    protected abstract boolean cancelWaitingTask(long var1);

    public AbstractJobManager(IdGenerator idGenerator, SupervisorRegistry discoveryWorker, TaskDispatcher taskDispatcher, WorkerServiceClient workerServiceClient) {
        this.idGenerator = idGenerator;
        this.discoveryWorker = discoveryWorker;
        this.taskDispatcher = taskDispatcher;
        this.workerServiceClient = workerServiceClient;
    }
}

