/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.thread;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.core.base.AbstractHeartbeatThread;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class WaitingInstanceScanner
extends AbstractHeartbeatThread {
    private final DoInLocked doInLocked;
    private final SchedulerJobManager schedulerJobManager;
    private final long beforeMilliseconds;

    public WaitingInstanceScanner(long heartbeatPeriodMilliseconds, DoInLocked doInLocked, SchedulerJobManager schedulerJobManager) {
        super(heartbeatPeriodMilliseconds);
        this.doInLocked = doInLocked;
        this.schedulerJobManager = schedulerJobManager;
        this.beforeMilliseconds = this.heartbeatPeriodMs << 3;
    }

    protected boolean heartbeat() {
        if (this.schedulerJobManager.hasNotDiscoveredWorkers()) {
            this.log.warn("Not discovered worker.");
            return true;
        }
        Boolean result = (Boolean)this.doInLocked.action(this::process);
        return result != null && result != false;
    }

    private boolean process() {
        Date now = new Date();
        Date expireTime = new Date(now.getTime() - this.beforeMilliseconds);
        List<SchedInstance> instances = this.schedulerJobManager.findExpireWaiting(expireTime, 200);
        if (CollectionUtils.isEmpty(instances)) {
            return true;
        }
        for (SchedInstance instance : instances) {
            this.processEach(instance, now);
        }
        return instances.size() < 200;
    }

    private void processEach(SchedInstance instance, Date now) {
        if (!this.schedulerJobManager.renewUpdateTime(instance, now)) {
            return;
        }
        List<SchedTask> tasks = this.schedulerJobManager.findMediumTaskByInstanceId(instance.getInstanceId());
        List waitingTasks = Collects.filter(tasks, e -> ExecuteState.WAITING.equals(e.getExecuteState()));
        if (CollectionUtils.isNotEmpty((Collection)waitingTasks)) {
            List redispatchingTasks = Collects.filter((List)waitingTasks, e -> this.schedulerJobManager.isDeadWorker(e.getWorker()));
            if (CollectionUtils.isEmpty((Collection)redispatchingTasks)) {
                return;
            }
            SchedJob schedJob = this.schedulerJobManager.getJob(instance.getJobId());
            if (schedJob == null) {
                this.log.error("Scanned waiting state instance not found job: {}", (Object)instance.getJobId());
                return;
            }
            if (this.schedulerJobManager.hasNotDiscoveredWorkers(schedJob.getJobGroup())) {
                this.log.error("Scanned waiting state instance not discovered worker: {} | {}", (Object)instance.getInstanceId(), (Object)schedJob.getJobGroup());
                return;
            }
            this.log.info("Scanned waiting state instance re-dispatch task: {}", (Object)instance.getInstanceId());
            this.schedulerJobManager.dispatch(schedJob, instance, redispatchingTasks);
        } else {
            if (tasks.stream().allMatch(e -> ExecuteState.of((Integer)e.getExecuteState()).isTerminal())) {
                SchedInstance reloadInstance = this.schedulerJobManager.getInstance(instance.getInstanceId());
                if (reloadInstance == null) {
                    this.log.error("Scanned waiting state instance not exists: {}", (Object)instance.getInstanceId());
                    return;
                }
                if (RunState.of((Integer)reloadInstance.getRunState()).isTerminal()) {
                    return;
                }
            }
            this.log.info("Scanned waiting state instance was dead: {}", (Object)instance.getInstanceId());
            this.schedulerJobManager.purgeInstance(instance.getInstanceId());
        }
    }
}

