/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.web.controller;

import cn.ponfee.scheduler.common.model.Result;
import cn.ponfee.scheduler.common.spring.BaseController;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import cn.ponfee.scheduler.supervisor.web.converter.SchedJobConverter;
import cn.ponfee.scheduler.supervisor.web.request.AddSchedJobRequest;
import cn.ponfee.scheduler.supervisor.web.request.UpdateSchedJobRequest;
import cn.ponfee.scheduler.supervisor.web.response.SchedInstanceResponse;
import cn.ponfee.scheduler.supervisor.web.response.SchedJobResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Supervisor openapi", description="cn.ponfee.scheduler.supervisor.web.controller.ApiController")
@RestController
@RequestMapping(value={"api"})
public class ApiController
extends BaseController {
    private static final String DEFAULT_USER = "0";
    private final SchedulerJobManager schedulerJobManager;

    public ApiController(SchedulerJobManager schedulerJobManager) {
        this.schedulerJobManager = schedulerJobManager;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody AddSchedJobRequest req) {
        SchedJob schedJob = req.tosSchedJob();
        schedJob.setCreatedBy(DEFAULT_USER);
        schedJob.setUpdatedBy(DEFAULT_USER);
        this.schedulerJobManager.addJob(schedJob);
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody UpdateSchedJobRequest req) {
        this.log.info("Do updating sched job {}", (Object)req.getJobId());
        SchedJob schedJob = req.tosSchedJob();
        schedJob.setUpdatedBy(DEFAULT_USER);
        this.schedulerJobManager.updateJob(schedJob);
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        this.log.info("Do deleting sched job {}", (Object)jobId);
        this.schedulerJobManager.deleteJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJobResponse> getJob(@RequestParam(value="jobId") long jobId) {
        SchedJob schedJob = this.schedulerJobManager.getJob(jobId);
        return Result.success((Object)SchedJobConverter.INSTANCE.convert(schedJob));
    }

    @PostMapping(value={"job/disable"})
    public Result<Boolean> disableJob(@RequestParam(value="jobId") long jobId) {
        this.log.info("Do disable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.DISABLE));
    }

    @PostMapping(value={"job/enable"})
    public Result<Boolean> enableJob(@RequestParam(value="jobId") long jobId) {
        this.log.info("Do enable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.ENABLE));
    }

    @PostMapping(value={"job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        this.log.info("Do manual trigger the sched job {}", (Object)jobId);
        this.schedulerJobManager.triggerJob(jobId);
        return Result.success();
    }

    @PostMapping(value={"instance/pause"})
    public Result<Boolean> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        this.log.info("Do pausing sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.pauseInstance(instanceId));
    }

    @PostMapping(value={"instance/cancel"})
    public Result<Boolean> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        this.log.info("Do canceling sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.cancelInstance(instanceId, Operations.MANUAL_CANCEL));
    }

    @PostMapping(value={"instance/resume"})
    public Result<Boolean> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        this.log.info("Do resuming sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.resumeInstance(instanceId));
    }

    @PutMapping(value={"instance/force_change_state"})
    public Result<Void> forceChangeState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="targetExecuteState") int targetExecuteState) {
        ExecuteState.of((Integer)targetExecuteState);
        this.log.info("Do force change state {} | {}", (Object)instanceId, (Object)targetExecuteState);
        this.schedulerJobManager.forceChangeState(instanceId, targetExecuteState);
        return Result.success();
    }

    @DeleteMapping(value={"instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        this.log.info("Do deleting sched instance {}", (Object)instanceId);
        this.schedulerJobManager.deleteInstance(instanceId);
        return Result.success();
    }

    @GetMapping(value={"instance/get"})
    public Result<SchedInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId) {
        SchedInstance instance = this.schedulerJobManager.getInstance(instanceId);
        if (instance == null) {
            return Result.success(null);
        }
        List<SchedTask> tasks = this.schedulerJobManager.findLargeTaskByInstanceId(instanceId);
        return Result.success((Object)SchedInstanceResponse.of(instance, tasks));
    }
}

