/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.web.response;

import cn.ponfee.scheduler.common.base.ToJsonString;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.web.converter.SchedJobConverter;
import cn.ponfee.scheduler.supervisor.web.response.SchedTaskResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class SchedInstanceResponse
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -6772222626245934369L;
    private Long instanceId;
    private Long rootInstanceId;
    private Long parentInstanceId;
    private Long workflowInstanceId;
    private Long jobId;
    private Long triggerTime;
    private Integer runType;
    private Integer runState;
    private Date runStartTime;
    private Date runEndTime;
    private Long runDuration;
    private Integer retriedCount;
    private String attach;
    private List<SchedTaskResponse> tasks;

    public static SchedInstanceResponse of(SchedInstance instance, List<SchedTask> tasks) {
        if (instance == null) {
            return null;
        }
        SchedInstanceResponse instanceResponse = SchedJobConverter.INSTANCE.convert(instance);
        instanceResponse.setTasks(Collects.convert(tasks, SchedJobConverter.INSTANCE::convert));
        return instanceResponse;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getRootInstanceId() {
        return this.rootInstanceId;
    }

    public Long getParentInstanceId() {
        return this.parentInstanceId;
    }

    public Long getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public Integer getRunType() {
        return this.runType;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public Long getRunDuration() {
        return this.runDuration;
    }

    public Integer getRetriedCount() {
        return this.retriedCount;
    }

    public String getAttach() {
        return this.attach;
    }

    public List<SchedTaskResponse> getTasks() {
        return this.tasks;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setRootInstanceId(Long rootInstanceId) {
        this.rootInstanceId = rootInstanceId;
    }

    public void setParentInstanceId(Long parentInstanceId) {
        this.parentInstanceId = parentInstanceId;
    }

    public void setWorkflowInstanceId(Long workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setTriggerTime(Long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setRunType(Integer runType) {
        this.runType = runType;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public void setRunEndTime(Date runEndTime) {
        this.runEndTime = runEndTime;
    }

    public void setRunDuration(Long runDuration) {
        this.runDuration = runDuration;
    }

    public void setRetriedCount(Integer retriedCount) {
        this.retriedCount = retriedCount;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setTasks(List<SchedTaskResponse> tasks) {
        this.tasks = tasks;
    }
}

