/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.common.util.Networks;
import cn.ponfee.scheduler.core.base.Supervisor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={CurrentSupervisorConfiguration.class})
public @interface EnableSupervisor {

    @ConditionalOnClass(value={Supervisor.class})
    @ConditionalOnProperty(value={"server.port"})
    @AutoConfigureOrder(value=-2147483648)
    public static class CurrentSupervisorConfiguration {
        @Bean(value={"currentWorker"})
        @Order(value=-2147483648)
        @ConditionalOnMissingBean
        public Supervisor currentSupervisor(@Value(value="${server.port}") int port) {
            Supervisor currentSupervisor = new Supervisor(Networks.getHostIp(), port);
            try {
                ClassUtils.invoke(Class.forName(Supervisor.class.getName() + "$Current"), (String)"set", (Object[])new Object[]{currentSupervisor});
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Setting as current supervisor occur error.", e);
            }
            return currentSupervisor;
        }
    }
}

