/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.HttpProperties;
import cn.ponfee.scheduler.core.base.WorkerService;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.DiscoveryRestProxy;
import cn.ponfee.scheduler.registry.DiscoveryRestTemplate;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={WorkerRemoteConfiguration.class})
public @interface EnableWorkerRemote {

    @ConditionalOnClass(value={WorkerService.class})
    public static class WorkerRemoteConfiguration {
        @Bean(value={"workerClient"})
        @ConditionalOnMissingBean
        public WorkerService workerClient(HttpProperties properties, SupervisorRegistry supervisorRegistry, @Nullable @Qualifier(value="distributed.scheduler.object-mapper") ObjectMapper objectMapper) {
            DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().connectTimeout(properties.getConnectTimeout()).readTimeout(properties.getReadTimeout()).maxRetryTimes(properties.getMaxRetryTimes()).objectMapper(objectMapper != null ? objectMapper : Jsons.createObjectMapper((JsonInclude.Include)JsonInclude.Include.NON_NULL)).discoveryServer((Discovery)supervisorRegistry).build();
            return (WorkerService)DiscoveryRestProxy.create(WorkerService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
        }
    }
}

