/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.lock.DoInDatabaseLocked;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.spring.SpringContextHolder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class SupervisorConfiguration {
    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean(value={"scanJobLocked"})
    public DoInLocked scanJobLocked(@Qualifier(value="schedulerJDBCTemplate") JdbcTemplate jdbcTemplate) {
        return new DoInDatabaseLocked(jdbcTemplate, "SELECT `name` FROM sched_lock WHERE name='scan_job' FOR UPDATE");
    }

    @Bean(value={"scanTrackLocked"})
    public DoInLocked scanTrackLocked(@Qualifier(value="schedulerJDBCTemplate") JdbcTemplate jdbcTemplate) {
        return new DoInDatabaseLocked(jdbcTemplate, "SELECT `name` FROM sched_lock WHERE name='scan_track' FOR UPDATE");
    }
}

