/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor;

import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.configuration.SupervisorProperties;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import cn.ponfee.scheduler.supervisor.thread.ScanRunningTrackThread;
import cn.ponfee.scheduler.supervisor.thread.ScanTriggeringJobThread;
import cn.ponfee.scheduler.supervisor.thread.ScanWaitingTrackThread;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class SupervisorStartup
implements AutoCloseable {
    private final Supervisor currentSupervisor;
    private final ScanTriggeringJobThread scanTriggeringJobThread;
    private final ScanWaitingTrackThread scanWaitingTrackThread;
    private final ScanRunningTrackThread scanRunningTrackThread;
    private final TaskDispatcher taskDispatcher;
    private final SupervisorRegistry supervisorRegistry;
    private final AtomicBoolean started = new AtomicBoolean(false);

    private SupervisorStartup(Supervisor currentSupervisor, SupervisorProperties supervisorConfig, SupervisorRegistry supervisorRegistry, SchedulerJobManager schedulerJobManager, DoInLocked scanTriggeringJobLocker, DoInLocked scanWaitingTrackLocker, DoInLocked scanRunningTrackLocker, TaskDispatcher taskDispatcher) {
        Assert.notNull((Object)currentSupervisor, (String)"Current supervisor cannot null.");
        Assert.notNull((Object)supervisorConfig, (String)"Supervisor config cannot null.");
        Assert.notNull((Object)supervisorRegistry, (String)"Supervisor registry cannot null.");
        Assert.notNull((Object)schedulerJobManager, (String)"Scheduler job manager cannot null.");
        Assert.notNull((Object)scanTriggeringJobLocker, (String)"Scan triggering job locker cannot null.");
        Assert.notNull((Object)scanWaitingTrackLocker, (String)"Scan waiting track locker cannot null.");
        Assert.notNull((Object)scanRunningTrackLocker, (String)"Scan running track locker cannot null.");
        Assert.notNull((Object)taskDispatcher, (String)"Task dispatcher cannot null.");
        supervisorConfig.check();
        this.currentSupervisor = currentSupervisor;
        this.supervisorRegistry = supervisorRegistry;
        this.scanTriggeringJobThread = new ScanTriggeringJobThread(supervisorConfig.getScanTriggeringJobPeriodMs(), scanTriggeringJobLocker, schedulerJobManager);
        this.scanWaitingTrackThread = new ScanWaitingTrackThread(supervisorConfig.getScanWaitingTrackPeriodMs(), scanWaitingTrackLocker, schedulerJobManager);
        this.scanRunningTrackThread = new ScanRunningTrackThread(supervisorConfig.getScanRunningTrackPeriodMs(), scanRunningTrackLocker, schedulerJobManager);
        this.taskDispatcher = taskDispatcher;
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.scanTriggeringJobThread.start();
        this.scanWaitingTrackThread.start();
        this.scanRunningTrackThread.start();
        this.supervisorRegistry.register((Server)this.currentSupervisor);
    }

    @Override
    public void close() {
        Throwables.caught(() -> ((SupervisorRegistry)this.supervisorRegistry).close());
        Throwables.caught(() -> ((ScanRunningTrackThread)this.scanRunningTrackThread).toStop());
        Throwables.caught(() -> ((ScanWaitingTrackThread)this.scanWaitingTrackThread).toStop());
        Throwables.caught(() -> ((ScanTriggeringJobThread)this.scanTriggeringJobThread).toStop());
        Throwables.caught(() -> ((TaskDispatcher)this.taskDispatcher).close());
        Throwables.caught(() -> this.scanRunningTrackThread.doStop(1000L));
        Throwables.caught(() -> this.scanWaitingTrackThread.doStop(1000L));
        Throwables.caught(() -> this.scanTriggeringJobThread.doStop(1000L));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supervisor currentSupervisor;
        private SupervisorProperties supervisorConfig;
        private SupervisorRegistry supervisorRegistry;
        private SchedulerJobManager schedulerJobManager;
        private DoInLocked scanTriggeringJobLocker;
        private DoInLocked scanWaitingTrackLocker;
        private DoInLocked scanRunningTrackLocker;
        private TaskDispatcher taskDispatcher;

        private Builder() {
        }

        public Builder currentSupervisor(Supervisor currentSupervisor) {
            this.currentSupervisor = currentSupervisor;
            return this;
        }

        public Builder supervisorConfig(SupervisorProperties supervisorConfig) {
            this.supervisorConfig = supervisorConfig;
            return this;
        }

        public Builder supervisorRegistry(SupervisorRegistry supervisorRegistry) {
            this.supervisorRegistry = supervisorRegistry;
            return this;
        }

        public Builder schedulerJobManager(SchedulerJobManager schedulerJobManager) {
            this.schedulerJobManager = schedulerJobManager;
            return this;
        }

        public Builder scanTriggeringJobLocker(DoInLocked scanTriggeringJobLocker) {
            this.scanTriggeringJobLocker = scanTriggeringJobLocker;
            return this;
        }

        public Builder scanWaitingTrackLocker(DoInLocked scanWaitingTrackLocker) {
            this.scanWaitingTrackLocker = scanWaitingTrackLocker;
            return this;
        }

        public Builder scanRunningTrackLocker(DoInLocked scanRunningTrackLocker) {
            this.scanRunningTrackLocker = scanRunningTrackLocker;
            return this;
        }

        public Builder taskDispatcher(TaskDispatcher taskDispatcher) {
            this.taskDispatcher = taskDispatcher;
            return this;
        }

        public SupervisorStartup build() {
            return new SupervisorStartup(this.currentSupervisor, this.supervisorConfig, this.supervisorRegistry, this.schedulerJobManager, this.scanTriggeringJobLocker, this.scanWaitingTrackLocker, this.scanRunningTrackLocker, this.taskDispatcher);
        }
    }
}

