/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.base;

import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.base.WorkerService;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.handle.JobHandlerUtils;
import cn.ponfee.scheduler.core.handle.SplitTask;
import java.util.List;
import java.util.Objects;

public class WorkerServiceClient {
    private static final WorkerService LOCAL_WORKER_SERVICE = new WorkerService(){

        public boolean verify(String jobHandler, String jobParam) {
            return JobHandlerUtils.verify((String)jobHandler, (String)jobParam);
        }

        public List<SplitTask> split(String jobHandler, String jobParam) throws JobException {
            return JobHandlerUtils.split((String)jobHandler, (String)jobParam);
        }
    };
    private final Worker currentWorker;
    private final WorkerService remoteWorkerService;

    public WorkerServiceClient(Worker currentWorker, WorkerService remoteWorkerService) {
        this.currentWorker = currentWorker;
        this.remoteWorkerService = Objects.requireNonNull(remoteWorkerService);
    }

    public boolean verify(String group, String jobHandler, String jobParam) {
        return this.get(group).verify(jobHandler, jobParam);
    }

    public List<SplitTask> split(String group, String jobHandler, String jobParam) throws JobException {
        return this.get(group).split(jobHandler, jobParam);
    }

    private WorkerService get(String group) {
        return this.currentWorker != null && group.equals(this.currentWorker.getGroup()) ? LOCAL_WORKER_SERVICE : this.remoteWorkerService;
    }
}

