/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="distributed.scheduler.supervisor")
public class SupervisorProperties {
    private long scanTriggeringJobPeriodMs = 3000L;
    private long scanWaitingTrackPeriodMs = 5000L;
    private long scanRunningTrackPeriodMs = 30000L;

    public void check() {
        Assert.isTrue((this.scanTriggeringJobPeriodMs > 0L ? 1 : 0) != 0, (String)"Scan triggering job period ms must be greater than 0.");
        Assert.isTrue((this.scanWaitingTrackPeriodMs > 0L ? 1 : 0) != 0, (String)"Scan waiting track period ms must be greater than 0.");
        Assert.isTrue((this.scanRunningTrackPeriodMs > 0L ? 1 : 0) != 0, (String)"Scan running track period ms must be greater than 0.");
    }

    public long getScanTriggeringJobPeriodMs() {
        return this.scanTriggeringJobPeriodMs;
    }

    public long getScanWaitingTrackPeriodMs() {
        return this.scanWaitingTrackPeriodMs;
    }

    public long getScanRunningTrackPeriodMs() {
        return this.scanRunningTrackPeriodMs;
    }

    public void setScanTriggeringJobPeriodMs(long scanTriggeringJobPeriodMs) {
        this.scanTriggeringJobPeriodMs = scanTriggeringJobPeriodMs;
    }

    public void setScanWaitingTrackPeriodMs(long scanWaitingTrackPeriodMs) {
        this.scanWaitingTrackPeriodMs = scanWaitingTrackPeriodMs;
    }

    public void setScanRunningTrackPeriodMs(long scanRunningTrackPeriodMs) {
        this.scanRunningTrackPeriodMs = scanRunningTrackPeriodMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupervisorProperties)) {
            return false;
        }
        SupervisorProperties other = (SupervisorProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScanTriggeringJobPeriodMs() != other.getScanTriggeringJobPeriodMs()) {
            return false;
        }
        if (this.getScanWaitingTrackPeriodMs() != other.getScanWaitingTrackPeriodMs()) {
            return false;
        }
        return this.getScanRunningTrackPeriodMs() == other.getScanRunningTrackPeriodMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupervisorProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scanTriggeringJobPeriodMs = this.getScanTriggeringJobPeriodMs();
        result = result * 59 + (int)($scanTriggeringJobPeriodMs >>> 32 ^ $scanTriggeringJobPeriodMs);
        long $scanWaitingTrackPeriodMs = this.getScanWaitingTrackPeriodMs();
        result = result * 59 + (int)($scanWaitingTrackPeriodMs >>> 32 ^ $scanWaitingTrackPeriodMs);
        long $scanRunningTrackPeriodMs = this.getScanRunningTrackPeriodMs();
        result = result * 59 + (int)($scanRunningTrackPeriodMs >>> 32 ^ $scanRunningTrackPeriodMs);
        return result;
    }

    public String toString() {
        return "SupervisorProperties(scanTriggeringJobPeriodMs=" + this.getScanTriggeringJobPeriodMs() + ", scanWaitingTrackPeriodMs=" + this.getScanWaitingTrackPeriodMs() + ", scanRunningTrackPeriodMs=" + this.getScanRunningTrackPeriodMs() + ")";
    }
}

