/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.controller;

import cn.ponfee.scheduler.common.base.model.Result;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api"})
public class ApiController {
    private static final Logger LOG = LoggerFactory.getLogger(ApiController.class);
    private final SchedulerJobManager schedulerJobManager;

    public ApiController(SchedulerJobManager schedulerJobManager) {
        this.schedulerJobManager = schedulerJobManager;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody SchedJob job) {
        this.schedulerJobManager.addJob(job);
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody SchedJob job) {
        LOG.info("Do updating sched job {}", (Object)job.getJobId());
        this.schedulerJobManager.updateJob(job);
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.schedulerJobManager.deleteJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJob> getJob(@RequestParam(value="jobId") long jobId) {
        return Result.success((Object)this.schedulerJobManager.getJob(jobId));
    }

    @PostMapping(value={"job/disable"})
    public Result<Boolean> disableJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do disable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.DISABLE));
    }

    @PostMapping(value={"job/enable"})
    public Result<Boolean> enableJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do enable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.ENABLE));
    }

    @PostMapping(value={"job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        LOG.info("Do manual trigger the sched job {}", (Object)jobId);
        this.schedulerJobManager.trigger(jobId);
        return Result.success();
    }

    @PostMapping(value={"track/pause"})
    public Result<Boolean> pauseTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do pausing sched track {}", (Object)trackId);
        return Result.success((Object)this.schedulerJobManager.pauseTrack(trackId));
    }

    @PostMapping(value={"track/cancel"})
    public Result<Boolean> cancelTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do canceling sched track {}", (Object)trackId);
        return Result.success((Object)this.schedulerJobManager.cancelTrack(trackId, Operations.MANUAL_CANCEL));
    }

    @PostMapping(value={"track/resume"})
    public Result<Boolean> resumeTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do resuming sched track {}", (Object)trackId);
        return Result.success((Object)this.schedulerJobManager.resume(trackId));
    }

    @PostMapping(value={"track/fresume"})
    public Result<Void> forceResumeTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do force resuming sched track {}", (Object)trackId);
        this.schedulerJobManager.forceUpdateState(trackId, RunState.WAITING.value(), ExecuteState.WAITING.value());
        return Result.success();
    }

    @PutMapping(value={"track/fupdate_state"})
    public Result<Void> forceUpdateTrackState(@RequestParam(value="trackId") long trackId, @RequestParam(value="trackTargetState") int trackTargetState, @RequestParam(value="taskTargetState") int taskTargetState) {
        RunState.of((Integer)trackTargetState);
        ExecuteState.of((Integer)taskTargetState);
        LOG.info("Do force update sched track state {} | {} | {}", new Object[]{trackId, trackTargetState, taskTargetState});
        this.schedulerJobManager.forceUpdateState(trackId, trackTargetState, taskTargetState);
        return Result.success();
    }

    @DeleteMapping(value={"track/delete"})
    public Result<Void> deleteTrack(@RequestParam(value="trackId") long trackId) {
        LOG.info("Do deleting sched track {}", (Object)trackId);
        this.schedulerJobManager.deleteTrack(trackId);
        return Result.success();
    }

    @GetMapping(value={"track/get"})
    public Result<Object[]> getTrack(@RequestParam(value="trackId") long trackId) {
        return Result.success((Object)new Object[]{this.schedulerJobManager.getTrack(trackId), this.schedulerJobManager.findLargeTaskByTrackId(trackId)});
    }
}

